/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;

public class ExecutionEvents {
    private final Collection<Consumer<String>> onBeginMap = new ArrayList<Consumer<String>>();
    protected Consumer<Collection<String>> contextKeyCollector;
    protected TypeMapper typeMapper;
    protected TermMapper termMapper;
    protected Counter nodeCounter;
    protected Counter ttl;

    protected ExecutionEvents(Counter ttl, Counter nodeCounter, Consumer<Collection<String>> contextKeyCollector) {
        this.ttl = ttl;
        this.nodeCounter = nodeCounter;
        this.contextKeyCollector = contextKeyCollector;
    }

    public static ExecutionEvents of(Options options) {
        return new ExecutionEvents(options.timeout() != null ? new Ticker(options.timeout())::tick : null, null, null);
    }

    @Deprecated
    public void tick() throws JsonLdException {
        if (this.ttl != null) {
            this.ttl.increment();
        }
    }

    public ExecutionEvents start() throws JsonLdException {
        if (this.ttl != null) {
            this.ttl.increment();
        }
        return this;
    }

    public void beginMap(String parentKey) throws JsonLdException {
        if (this.nodeCounter != null) {
            this.nodeCounter.increment();
        }
        if (this.termMapper != null) {
            this.termMapper.onBeginMap(parentKey);
        }
        if (this.typeMapper != null) {
            this.typeMapper.onBeginMap(parentKey);
        }
    }

    public void endMap(String parentKey) throws JsonLdException {
        if (this.typeMapper != null) {
            this.typeMapper.onEndMap(parentKey);
        }
        if (this.termMapper != null) {
            this.termMapper.onEndMap(parentKey);
        }
    }

    public void beginList(String term) {
        if (this.termMapper != null) {
            this.termMapper.onBeginList(term);
        }
    }

    public void endList(String term) {
        if (this.termMapper != null) {
            this.termMapper.onEndList(term);
        }
    }

    public void term(String key, String uri) {
        if (this.termMapper != null) {
            this.termMapper.onTerm(key, uri);
        }
    }

    public ExecutionEvents termMapper(TermMapper termMapper) {
        this.termMapper = termMapper;
        return this;
    }

    public void type(String key, String type) throws JsonLdException {
        if (this.typeMapper != null) {
            this.typeMapper.onType(key, type);
        }
    }

    public ExecutionEvents keyTypeMapper(TypeMapper keyTypeMapper) {
        this.onBeginMap.add(keyTypeMapper::onBeginMap);
        this.typeMapper = keyTypeMapper;
        return this;
    }

    public void onContextKeys(Collection<String> keys) {
        if (this.contextKeyCollector != null) {
            this.contextKeyCollector.accept(keys);
        }
    }

    public boolean collectsContextKeys() {
        return this.contextKeyCollector != null;
    }

    public ExecutionEvents contextKeyCollector(Consumer<Collection<String>> consumer) {
        this.contextKeyCollector = consumer;
        return this;
    }

    public ExecutionEvents undefinedTermCollector(Consumer<String> collector) {
        return this;
    }

    @FunctionalInterface
    public static interface Counter {
        public void increment() throws JsonLdException;
    }

    static class Ticker {
        private final long ttl;
        private long ticker;

        private Ticker(Duration ttl) {
            this.ttl = ttl.toMillis();
            this.ticker = 0L;
        }

        void tick() throws JsonLdException {
            if (this.ticker == 0L) {
                this.ticker = System.currentTimeMillis();
                return;
            }
            long now = System.currentTimeMillis();
            long elapsed = this.ttl - (now - this.ticker);
            if (elapsed <= 0L) {
                this.ticker = 0L;
                throw new JsonLdException(JsonLdException.ErrorCode.PROCESSING_TIMEOUT_EXCEEDED);
            }
        }
    }

    @FunctionalInterface
    public static interface TermMapper {
        public void onTerm(String var1, String var2);

        default public void onBeginMap(String key) {
        }

        default public void onEndMap(String key) {
        }

        default public void onBeginList(String key) {
        }

        default public void onEndList(String key) {
        }
    }

    public static interface TypeMapper {
        public void onType(String var1, String var2);

        public void onBeginMap(String var1);

        public void onEndMap(String var1);

        default public void onBeginList(String key) {
        }

        default public void onEndList(String key) {
        }
    }

    static class NodeThrottle {
        private final int maxNodes;
        private int counter;

        private NodeThrottle(int maxNodes) {
            this.maxNodes = maxNodes;
            this.counter = 0;
        }

        void increment() throws JsonLdException {
            if (++this.counter >= this.maxNodes) {
                throw new JsonLdException(JsonLdException.ErrorCode.UNSPECIFIED);
            }
        }
    }
}

