/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeIOException;
import com.apicatalog.tree.io.TreeParser;
import com.apicatalog.web.media.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StaticLoader
implements DocumentLoader {
    private static final Logger LOGGER = Logger.getLogger(StaticLoader.class.getName());
    private final Map<URI, Document> resources;
    private final DocumentLoader loader;

    private StaticLoader(Map<URI, Document> resources, DocumentLoader loader) {
        this.resources = resources;
        this.loader = loader;
    }

    public static final Builder newBuilder() {
        return StaticLoader.newBuilder(Map.of());
    }

    public static final Builder copyOf(StaticLoader loader) {
        return new Builder(loader.resources, loader.loader);
    }

    public static final Builder newBuilder(Map<URI, Document> resources) {
        return new Builder(Objects.requireNonNull(resources), null);
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Document document = this.resources.getOrDefault(Objects.requireNonNull(url, "The url must not be null."), null);
        if (document != null) {
            return document;
        }
        if (this.loader != null) {
            return this.loader.loadDocument(url, options);
        }
        throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "URL [" + String.valueOf(url) + "] is not recogized and fallback loader is not set.");
    }

    public static final class Builder {
        private final Map<URI, Document> resources;
        private DocumentLoader loader;
        private MediaType contentType;
        private TreeParser parser;

        Builder(Map<URI, Document> resources, DocumentLoader loader) {
            this.resources = new LinkedHashMap<URI, Document>(resources);
            this.loader = loader;
            this.contentType = null;
            this.parser = null;
        }

        public Builder document(String url, Document document) {
            return this.document(URI.create(url), document);
        }

        public Builder document(URI url, Document document) {
            this.resources.put(url, document);
            return this;
        }

        Builder node(String url, MediaType contentType, TreeIO node) {
            return this.node(URI.create(url), contentType, node);
        }

        Builder node(URI url, MediaType contentType, TreeIO node) {
            this.resources.put(url, Document.of(node, contentType, url));
            return this;
        }

        public Builder parser(MediaType contentType, TreeParser parser) {
            this.contentType = contentType;
            this.parser = parser;
            return this;
        }

        public Builder parser(TreeParser parser) {
            this.parser = parser;
            return this;
        }

        public Builder classpath(String url, String resource) {
            Builder builder;
            block8: {
                InputStream is = StaticLoader.class.getResourceAsStream(resource);
                try {
                    builder = this.node(url, this.contentType != null ? this.contentType : FileLoader.fromFileExtension(resource), this.parser.parse(is));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TreeIOException | IOException e) {
                        LOGGER.log(Level.SEVERE, "An error [{0}] during loading static context [{1}]", new Object[]{e.getMessage(), resource});
                        return this;
                    }
                }
                is.close();
            }
            return builder;
        }

        public Builder classpath(Map<String, String> resources) {
            resources.forEach(this::classpath);
            return this;
        }

        public Builder fallback(DocumentLoader loader) {
            this.loader = loader;
            return this;
        }

        public StaticLoader build() {
            return new StaticLoader(Map.copyOf(this.resources), this.loader);
        }
    }
}

