/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.fromrdf;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.fromrdf.GraphMap;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.tree.io.TreeParser;
import com.apicatalog.tree.io.java.NativeAdapter;
import com.apicatalog.web.lang.LanguageTag;
import com.apicatalog.web.uri.UriUtils;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class QuadsToJsonLd
implements RdfQuadConsumer {
    public static final Map<String, Function<String, Object>> DEFAULT_NATIVE_ADAPTERS = Map.of("http://www.w3.org/2001/XMLSchema#string", s -> s, "http://www.w3.org/2001/XMLSchema#boolean", QuadsToJsonLd::toBoolean, "http://www.w3.org/2001/XMLSchema#int", QuadsToJsonLd::toLong, "http://www.w3.org/2001/XMLSchema#integer", QuadsToJsonLd::toLong, "http://www.w3.org/2001/XMLSchema#long", QuadsToJsonLd::toLong, "http://www.w3.org/2001/XMLSchema#float", QuadsToJsonLd::toDouble, "http://www.w3.org/2001/XMLSchema#double", QuadsToJsonLd::toDouble);
    protected boolean ordered = false;
    protected Options.RdfDirection rdfDirection = null;
    protected boolean useRdfType = false;
    protected boolean useXsdDecimal = false;
    protected UriValidationPolicy uriValidation;
    protected JsonLd.Version processingMode;
    protected TreeParser jsonParser = null;
    protected Map<String, Function<String, Object>> nativeTypes;
    protected GraphMap graphMap = new GraphMap();
    protected Map<String, Map<String, Boolean>> compoundLiteralSubjects;
    protected Map<String, GraphMap.Reference> referenceOnce = new LinkedHashMap<String, GraphMap.Reference>();

    public QuadsToJsonLd() {
        this.compoundLiteralSubjects = new LinkedHashMap<String, Map<String, Boolean>>();
        this.nativeTypes = Map.of();
        this.uriValidation = Options.DEFAULT_URI_VALIDATION;
        this.processingMode = JsonLd.Version.V1_1;
    }

    public QuadsToJsonLd ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public QuadsToJsonLd rdfDirection(Options.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public QuadsToJsonLd useNativeTypes(boolean useNativeTypes) {
        this.nativeTypes = useNativeTypes ? DEFAULT_NATIVE_ADAPTERS : Map.of();
        return this;
    }

    public QuadsToJsonLd useNativeTypes(Map<String, Function<String, Object>> converters) {
        this.nativeTypes = converters != null ? converters : Map.of();
        return this;
    }

    public QuadsToJsonLd useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public QuadsToJsonLd mode(JsonLd.Version processingMode) {
        this.processingMode = processingMode;
        return this;
    }

    public QuadsToJsonLd uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    public QuadsToJsonLd jsonParser(TreeParser jsonParser) {
        this.jsonParser = jsonParser;
        return this;
    }

    public QuadsToJsonLd options(Options options) {
        this.ordered = options.isOrdered();
        this.rdfDirection = options.rdfDirection();
        this.useNativeTypes(options.useNativeTypes());
        this.useRdfType = options.useRdfType();
        this.uriValidation = options.uriValidation();
        this.processingMode = options.mode();
        return this;
    }

    public QuadsToJsonLd reset() {
        this.graphMap.clear();
        this.referenceOnce.clear();
        this.compoundLiteralSubjects.clear();
        return this;
    }

    public Collection<?> toJsonLd() throws JsonLdException {
        Iterator<String> subjects;
        for (String graphName : this.graphMap.keys()) {
            if (this.compoundLiteralSubjects.containsKey(graphName)) {
                for (String cl : this.compoundLiteralSubjects.get(graphName).keySet()) {
                    GraphMap.Reference clEntry = this.referenceOnce.get(cl);
                    if (clEntry == null) continue;
                    Optional<Map<String, Object>> clNodeValue = this.graphMap.get(graphName, cl);
                    this.graphMap.remove(graphName, cl);
                    if (!clNodeValue.isPresent()) continue;
                    Map<String, Object> clNode = clNodeValue.get();
                    ArrayList clArray = new ArrayList();
                    for (Object clReference : (Collection)this.graphMap.get(clEntry.graphName(), clEntry.subject(), clEntry.property()).map(NativeAdapter::asCollection).orElse(List.of())) {
                        Map clReferenceObject;
                        if (clReference == null || !(clReference instanceof Map) || !(clReferenceObject = (Map)clReference).containsKey("@id") || !cl.equals(clReferenceObject.get("@id"))) continue;
                        LinkedHashMap<String, Object> clObject = new LinkedHashMap<String, Object>(clReferenceObject);
                        clObject.remove("@id");
                        clObject.put("@value", QuadsToJsonLd.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#value"), "@value"));
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#language")) {
                            String langString;
                            Object lang = QuadsToJsonLd.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#language"), "@value");
                            if (!(lang instanceof String) || !LanguageTag.isWellFormed(langString = (String)lang)) {
                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                            }
                            clObject.put("@language", lang);
                        }
                        if (clNode.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction")) {
                            String dirString;
                            Object direction = QuadsToJsonLd.flatten(clNode.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#direction"), "@value");
                            if (!(direction instanceof String) || !"ltr".equalsIgnoreCase(dirString = (String)direction) && !"rtl".equalsIgnoreCase(dirString)) {
                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_BASE_DIRECTION);
                            }
                            clObject.put("@direction", direction);
                        }
                        clArray.add(clObject);
                    }
                    this.graphMap.set(clEntry.graphName(), clEntry.subject(), clEntry.property(), clArray);
                }
            }
            if (!this.graphMap.contains(graphName, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) continue;
            for (GraphMap.Reference usage : this.graphMap.getUsages(graphName, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
                Map<Object, Object> node = this.graphMap.get(usage.graphName(), usage.subject()).orElse(Map.of());
                ArrayList list = new ArrayList();
                ArrayList<String> listNodes = new ArrayList<String>();
                String nodeId = (String)node.get("@id");
                while ("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest".equals(usage.property()) && BlankNode.isWellFormed(nodeId) && this.referenceOnce.get(nodeId) != null && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#first") && node.containsKey("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest") && ((Collection)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).size() == 1 && ((Collection)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest")).size() == 1 && (node.size() == 3 || node.size() == 4 && node.containsKey("@type") && ((Collection)node.get("@type")).size() == 1 && ((Collection)node.get("@type")).contains("http://www.w3.org/1999/02/22-rdf-syntax-ns#List"))) {
                    list.add(0, ((Collection)node.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#first")).iterator().next());
                    listNodes.add(nodeId);
                    usage = this.referenceOnce.get(nodeId);
                    Optional<Map<String, Object>> nextNode = this.graphMap.get(usage.graphName(), usage.subject());
                    if (nextNode.isPresent() && (node = nextNode.get()).containsKey("@id") && !UriUtils.isAbsoluteUri(nodeId = (String)node.get("@id"), this.uriValidation)) continue;
                    break;
                }
                Map<String, Object> head = usage.value();
                head.remove("@id");
                head.put("@list", list);
                listNodes.forEach(nid -> this.graphMap.remove(graphName, (String)nid));
            }
        }
        ArrayList result = new ArrayList();
        Iterator<String> iterator = subjects = this.ordered ? this.graphMap.keys("@default").stream().sorted().iterator() : this.graphMap.keys("@default").iterator();
        while (subjects.hasNext()) {
            String subject = subjects.next();
            Map node = this.graphMap.get("@default", subject).orElseGet(() -> new LinkedHashMap());
            if (this.graphMap.contains(subject)) {
                Iterator<String> keys;
                ArrayList array = new ArrayList();
                Iterator<String> iterator2 = keys = this.ordered ? this.graphMap.keys(subject).stream().sorted().iterator() : this.graphMap.keys(subject).iterator();
                while (keys.hasNext()) {
                    Map entry = this.graphMap.get(subject, keys.next()).orElse(Map.of());
                    if (entry.size() <= 1 && entry.containsKey("@id")) continue;
                    array.add(Map.copyOf(entry));
                }
                node.put("@graph", array);
            }
            if (node.size() <= 1 && node.containsKey("@id")) continue;
            result.add(Map.copyOf(node));
        }
        return result;
    }

    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) throws RdfConsumerException {
        String graphName;
        String string = graphName = graph == null ? "@default" : graph;
        if (direction != null || datatype != null && ((String)datatype).startsWith("https://www.w3.org/ns/i18n#")) {
            datatype = "https://www.w3.org/ns/i18n#";
            if (language != null) {
                datatype = (String)datatype + language;
                language = null;
            }
            if (direction != null) {
                datatype = (String)datatype + "_" + direction;
                direction = null;
            }
        }
        if (!this.compoundLiteralSubjects.containsKey(graphName)) {
            this.compoundLiteralSubjects.put(graphName, new LinkedHashMap());
        }
        if (!"@default".equals(graphName) && !this.graphMap.contains("@default", graphName)) {
            this.graphMap.set("@default", graphName, "@id", graphName);
        }
        Map<String, Boolean> compoundMap = this.compoundLiteralSubjects.get(graphName);
        if (!this.graphMap.contains(graphName, subject)) {
            this.graphMap.set(graphName, subject, "@id", subject);
        }
        if (Options.RdfDirection.COMPOUND_LITERAL == this.rdfDirection && "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction".equals(predicate)) {
            compoundMap.put(subject, Boolean.TRUE);
        }
        if (!RdfQuadConsumer.isLiteral((String)datatype, (String)language, (String)direction) && !this.graphMap.contains(graphName, object)) {
            this.graphMap.set(graphName, object, "@id", object);
        }
        if (!this.useRdfType && "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(predicate) && !RdfQuadConsumer.isLiteral((String)datatype, (String)language, (String)direction)) {
            Optional<Object> type = this.graphMap.get(graphName, subject, "@type");
            if (type.isPresent()) {
                ArrayList<String> types = new ArrayList<String>((Collection)type.get());
                types.add(object);
                this.graphMap.set(graphName, subject, "@type", types);
            } else {
                this.graphMap.set(graphName, subject, "@type", Set.of(object));
            }
            return this;
        }
        Map<String, Object> value = this.toObject(object, (String)datatype, language, direction);
        Optional<Object> predicateValue = this.graphMap.get(graphName, subject, predicate);
        if (predicateValue.isPresent()) {
            Collection array = (Collection)predicateValue.get();
            if (!array.contains(value)) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(array);
                list.add(value);
                this.graphMap.set(graphName, subject, predicate, list);
            }
        } else {
            this.graphMap.set(graphName, subject, predicate, List.of(value));
        }
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil".equals(object)) {
            this.graphMap.addUsage(graphName, object, new GraphMap.Reference(graphName, subject, predicate, value));
        } else if (this.referenceOnce.containsKey(object)) {
            this.referenceOnce.put(object, null);
        } else if (RdfQuadConsumer.isBlank((String)object)) {
            this.referenceOnce.put(object, new GraphMap.Reference(graphName, subject, predicate, value));
        }
        return this;
    }

    Map<String, Object> toObject(String object, String datatype, String langTag, String direction) throws RdfConsumerException {
        if (!RdfQuadConsumer.isLiteral((String)datatype, (String)langTag, (String)direction)) {
            LinkedHashMap<String, Object> ref = new LinkedHashMap<String, Object>(1);
            ref.put("@id", object);
            return ref;
        }
        Object convertedValue = null;
        if (!this.nativeTypes.isEmpty()) {
            if (datatype != null) {
                Function<String, Object> convertor = this.nativeTypes.get(datatype);
                if (convertor != null && (convertedValue = convertor.apply(object)) != null) {
                    return Map.of("@value", convertedValue);
                }
                return Map.of("@value", object, "@type", datatype);
            }
            return Map.of("@value", object);
        }
        if (this.jsonParser != null && this.processingMode != JsonLd.Version.V1_0 && "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON".equals(datatype)) {
            try {
                convertedValue = this.jsonParser.parse((InputStream)new ByteArrayInputStream(object.getBytes()));
                if (convertedValue == null) {
                    HashMap<String, String> result = new HashMap<String, String>(2);
                    result.put("@type", "@json");
                    result.put("@value", null);
                    return Map.copyOf(result);
                }
                return Map.of("@value", convertedValue, "@type", "@json");
            }
            catch (Exception e) {
                throw new RdfConsumerException((Throwable)new JsonLdException(JsonLdException.ErrorCode.INVALID_JSON_LITERAL, (Throwable)e));
            }
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(5);
        String type = null;
        if (Options.RdfDirection.I18N_DATATYPE == this.rdfDirection && datatype != null && datatype.startsWith("https://www.w3.org/ns/i18n#")) {
            convertedValue = object;
            String dirLang = datatype.substring("https://www.w3.org/ns/i18n#".length());
            int directionIndex = dirLang.indexOf(95);
            if (directionIndex > 1) {
                result.put("@language", dirLang.substring(0, directionIndex));
                result.put("@direction", dirLang.substring(directionIndex + 1));
            } else if (directionIndex == 0) {
                result.put("@direction", dirLang.substring(1));
            } else if (directionIndex == -1) {
                result.put("@language", dirLang);
            }
        } else if (langTag != null) {
            result.put("@language", langTag);
        } else if (datatype != null && !"http://www.w3.org/2001/XMLSchema#string".equals(datatype)) {
            type = datatype;
        }
        result.put("@value", convertedValue != null ? convertedValue : object);
        if (type != null) {
            result.put("@type", type);
        }
        return result;
    }

    public static Boolean toBoolean(String value) {
        if ("true".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "0".equals(value)) {
            return false;
        }
        return null;
    }

    public static Long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double toDouble(String value) {
        try {
            Double number = Double.parseDouble(value);
            if (!number.isInfinite() && !number.isNaN()) {
                return number;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static BigDecimal toDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static Object flatten(Object value, String key) {
        Collection array;
        Object result = value;
        if (result instanceof Collection && (array = (Collection)result).size() == 1) {
            result = array.iterator().next();
        }
        if (result instanceof Map) {
            Map map = (Map)result;
            result = map.get(key);
        }
        return result;
    }
}

