/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.framing;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class ValuePatternMatcher {
    public static boolean match(Map<String, ?> pattern, Map<?, ?> node) {
        Object valuePattern = pattern.getOrDefault("@value", null);
        Object typePattern = pattern.getOrDefault("@type", null);
        Object langPattern = pattern.getOrDefault("@language", null);
        return valuePattern == null && typePattern == null && langPattern == null || ValuePatternMatcher.matchValue(valuePattern, node) && ValuePatternMatcher.matchType(typePattern, node) && ValuePatternMatcher.matchLanguage(langPattern, node);
    }

    private static boolean matchValue(Object pattern, Map<?, ?> node) {
        Collection array;
        Object value = node.getOrDefault("@value", null);
        return value != null && ValuePatternMatcher.isWildcard(pattern, new String[0]) || pattern != null && value != null && (pattern instanceof Collection && (array = (Collection)pattern).contains(value) || pattern.equals(value));
    }

    private static boolean matchType(Object pattern, Map<?, ?> node) {
        Collection array;
        Object type = node.getOrDefault("@type", null);
        return type != null && ValuePatternMatcher.isWildcard(pattern, new String[0]) || type == null && ValuePatternMatcher.isNone(pattern) || pattern != null && (pattern instanceof Collection && (array = (Collection)pattern).contains(type) || pattern.equals(type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean matchLanguage(Object pattern, Map<?, ?> node) {
        String lang;
        Object obj = node.get("@language");
        if (obj instanceof String) {
            String stringValue = (String)obj;
            v0 = stringValue.toLowerCase();
        } else {
            v0 = lang = null;
        }
        if (lang != null) {
            if (ValuePatternMatcher.isWildcard(pattern, new String[0])) return true;
        }
        if (lang == null) {
            if (ValuePatternMatcher.isNone(pattern)) return true;
        }
        if (lang == null) return false;
        if (pattern == null) return false;
        if (pattern instanceof Collection) {
            Collection col = (Collection)pattern;
            if (col.stream().map(String.class::cast).anyMatch(lang::equalsIgnoreCase)) return true;
        }
        if (!pattern.equals(lang)) return false;
        return true;
    }

    protected static final boolean isWildcard(Object value, String ... except) {
        Object e;
        Collection array;
        Map frame = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                return true;
            }
            frame = map;
        } else if (value instanceof Collection && (array = (Collection)value).size() == 1 && (e = array.iterator().next()) instanceof Map) {
            Map map;
            frame = map = (Map)e;
        }
        return frame != null && (frame.isEmpty() || Set.of("@default", "@omitDefault", "@embed", "@explicit", "@requireAll", except).containsAll(frame.keySet()));
    }

    protected static final boolean isNone(Object value) {
        Collection array;
        return value == null || value instanceof Collection && (array = (Collection)value).isEmpty();
    }
}

