/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.lang.Direction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class InverseContext {
    private final Set<String> variables = new HashSet<String>();
    private final Map<Key, Map<String, String>> mapping = new LinkedHashMap<Key, Map<String, String>>();

    public boolean contains(String variable) {
        return this.variables.contains(variable);
    }

    public boolean contains(String variable, String container, String type) {
        return this.mapping.containsKey(new Key(variable, container, type));
    }

    public InverseContext setIfAbsent(String variable, String container, String type, String key, String value) {
        this.variables.add(variable);
        this.mapping.computeIfAbsent(new Key(variable, container, type), k -> new LinkedHashMap()).putIfAbsent(key, value);
        return this;
    }

    public Optional<String> get(String variable, String container, String type, String key) {
        return Optional.ofNullable(this.mapping.get(new Key(variable, container, type))).map(inner -> (String)inner.get(key));
    }

    public static InverseContext newContext(ActiveContext activeContext) {
        InverseContext result = new InverseContext();
        String defaultLanguage = activeContext.getDefaultLanguage() != null ? activeContext.getDefaultLanguage().toLowerCase() : "@none";
        activeContext.getTerms().stream().filter(termName -> activeContext.findTerm((String)termName).map(TermDefinition::getUriMapping).isPresent()).sorted().forEach(termName -> InverseContext.processTerm(activeContext, termName, result, activeContext.findTerm((String)termName).map(TermDefinition::getUriMapping).get(), defaultLanguage));
        return result;
    }

    private static void processTerm(ActiveContext activeContext, String termName, InverseContext result, String variableValue, String defaultLanguage) {
        String container = activeContext.findTerm(termName).map(TermDefinition::getContainerMapping).filter(collection -> !collection.isEmpty()).orElseGet(() -> Arrays.asList("@none")).stream().sorted().collect(Collectors.joining());
        result.setIfAbsent(variableValue, container, "@any", "@none", termName);
        if (activeContext.findTerm(termName).filter(TermDefinition::isReverseProperty).isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", "@reverse", termName);
            return;
        }
        Optional<String> typeMapping = activeContext.findTerm(termName).map(TermDefinition::getTypeMapping);
        if (typeMapping.filter("@none"::equals).isPresent()) {
            result.setIfAbsent(variableValue, container, "@language", "@any", termName).setIfAbsent(variableValue, container, "@type", "@any", termName);
            return;
        }
        if (typeMapping.isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", typeMapping.get(), termName);
            return;
        }
        Optional<String> languageMapping = activeContext.findTerm(termName).map(TermDefinition::getLanguageMapping);
        Optional<Direction> directionMapping = activeContext.findTerm(termName).map(TermDefinition::getDirectionMapping);
        if (languageMapping.isPresent()) {
            String langDir;
            String language = languageMapping.get();
            if (directionMapping.isPresent()) {
                Direction direction = directionMapping.get();
                langDir = language != null ? (direction != Direction.NULL ? language.concat("_").concat(direction.name()).toLowerCase() : language.toLowerCase()) : (direction != Direction.NULL ? "_".concat(direction.name().toLowerCase()) : "@null");
            } else {
                langDir = language != null ? language.toLowerCase() : "@null";
            }
            result.setIfAbsent(variableValue, container, "@language", langDir, termName);
        } else if (directionMapping.isPresent()) {
            String direction = directionMapping.filter(d -> d != Direction.NULL).map(d -> "_".concat(d.name().toLowerCase())).orElse("@none");
            result.setIfAbsent(variableValue, container, "@language", direction, termName);
        } else {
            String langDir = activeContext.getDefaultBaseDirection() != null ? (activeContext.getDefaultLanguage() != null ? activeContext.getDefaultLanguage() : "").concat("_").concat(activeContext.getDefaultBaseDirection().name()).toLowerCase() : defaultLanguage;
            result.setIfAbsent(variableValue, container, "@language", langDir, termName).setIfAbsent(variableValue, container, "@language", "@none", termName).setIfAbsent(variableValue, container, "@type", "@none", termName);
        }
    }

    private record Key(String variable, String container, String type) {
    }
}

