/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.compaction.UriCompaction;
import com.apicatalog.jsonld.compaction.ValueCompaction;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.jsonld.processor.ExecutionEvents;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Compaction {
    private static final Collection<String> DILV_KEYWORDS = Arrays.asList("@direction", "@index", "@language", "@value");
    private final Context context;
    private final Options options;
    private final ExecutionEvents runtime;
    private boolean compactArrays;
    private boolean ordered;

    private Compaction(Context context, Options options, ExecutionEvents runtime) {
        this.context = context;
        this.options = options;
        this.runtime = runtime;
        this.compactArrays = false;
        this.ordered = false;
    }

    public static Compaction with(Context activeContext, Options options, ExecutionEvents runtime) {
        return new Compaction(activeContext, options, runtime);
    }

    public Compaction compactArrays(boolean compactArrays) {
        this.compactArrays = compactArrays;
        return this;
    }

    public Compaction ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public Object compact(Object element) throws JsonLdException {
        return this.compact(null, element);
    }

    public Object compact(String activeProperty, Object element) throws JsonLdException {
        if (element instanceof Collection) {
            Collection array = (Collection)element;
            return this.compactArray(activeProperty, array);
        }
        if (element instanceof Map) {
            Map map = (Map)element;
            return this.compactObject(activeProperty, map);
        }
        return element;
    }

    public Object compactArray(String activeProperty, Collection<?> array) throws JsonLdException {
        Optional<TermDefinition> activePropertyDefinition = this.context.findTerm(activeProperty);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object item : array) {
            Object compactedItem = Compaction.with(this.context, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, item);
            if (compactedItem == null) continue;
            result.add(compactedItem);
        }
        if (result.isEmpty() || result.size() > 1 || !this.compactArrays || "@graph".equals(activeProperty) || "@set".equals(activeProperty) || activePropertyDefinition.filter(d -> d.hasContainerMapping("@list") || d.hasContainerMapping("@set")).isPresent()) {
            return result;
        }
        return result.get(0);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Object compactObject(String activeProperty, Map<String, ?> object) throws JsonLdException {
        typeContext = this.context;
        activeContext = this.context;
        activePropertyDefinition = activeContext.findTerm(activeProperty);
        if (!(activeContext.getPreviousContext() == null || object.containsKey("@value") || object.containsKey("@id") && object.size() == 1)) {
            activeContext = activeContext.getPreviousContext();
        }
        if (activePropertyDefinition.map((Function<TermDefinition, TreeIO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLocalContext(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Lcom/apicatalog/tree/io/TreeIO;)()).isPresent()) {
            localContext = activePropertyDefinition.get().getLocalContext();
            activeContext = activeContext.newContext(this.options.loader(), this.runtime).overrideProtected(true).build(localContext, activePropertyDefinition.get().getBaseUrl());
        }
        if ((object.containsKey("@value") || object.containsKey("@id")) && (!this.options.isRdfStar() || !object.containsKey("@annotation")) && ((result = ValueCompaction.compact(activeContext, object, activeProperty, this.options)) != null && NativeAdapter.instance().type(result).isScalar() || activePropertyDefinition.map((Function<TermDefinition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getTypeMapping(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Ljava/lang/String;)()).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)"@json")).isPresent())) {
            return result;
        }
        if (LdAdapter.isList(object) && activePropertyDefinition.filter((Predicate<TermDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$compactObject$1(com.apicatalog.jsonld.context.TermDefinition ), (Lcom/apicatalog/jsonld/context/TermDefinition;)Z)()).isPresent()) {
            return Compaction.with(activeContext, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, object.get("@list"));
        }
        insideReverse = "@reverse".equals(activeProperty);
        result = new LinkedHashMap<String, Object>();
        if (object.containsKey("@type")) {
            compactedTypes = new ArrayList<String>();
            for (E type : NativeAdapter.asCollection(object.get("@type"))) {
                compactedTypes.add(UriCompaction.withVocab(activeContext, (String)type, this.options));
            }
            Collections.sort(compactedTypes);
            for (String term : compactedTypes) {
                termDefinition = typeContext.findTerm(term).orElse(null);
                if (termDefinition == null || termDefinition.getLocalContext() == null) continue;
                localContext = termDefinition.getLocalContext();
                activeContext = activeContext.newContext(this.options.loader(), this.runtime).propagate(false).build(localContext, termDefinition.getBaseUrl());
            }
        }
        v0 /* !! */  = keys = this.ordered != false ? object.keySet().stream().sorted().iterator() : object.keySet().iterator();
        while (keys.hasNext()) {
            expandedProperty = keys.next();
            expandedValue = object.get(expandedProperty);
            if ("@id".equals(expandedProperty)) {
                compactedValue = null;
                if (expandedValue instanceof String) {
                    stringValue = (String)expandedValue;
                    compactedValue = UriCompaction.compact(activeContext, stringValue, this.options);
                } else if (this.options.isRdfStar() && LdAdapter.isEmbedded(expandedValue)) {
                    compactedValue = Compaction.with(activeContext, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact(expandedValue);
                }
                result.put(UriCompaction.withVocab(activeContext, expandedProperty, this.options), compactedValue);
                continue;
            }
            if ("@type".equals(expandedProperty)) {
                if (expandedValue instanceof String) {
                    stringValue = (String)expandedValue;
                    compactedValue = UriCompaction.withVocab(typeContext, stringValue, this.options);
                } else if (expandedValue instanceof Collection) {
                    arrayValue = (Collection)expandedValue;
                    compactedArray = new ArrayList<String>(arrayValue.size());
                    for (E expandedType : arrayValue) {
                        compactedArray.add(UriCompaction.withVocab(typeContext, (String)expandedType, this.options));
                    }
                    compactedValue = compactedArray;
                } else {
                    throw new JsonLdException(JsonLdException.ErrorCode.INVALID_TYPE_VALUE, "@type value is not valid [" + String.valueOf(expandedValue) + "].");
                }
                alias = UriCompaction.withVocab(activeContext, expandedProperty, this.options);
                asArray = this.compactArrays == false || activeContext.isV11() != false && activeContext.findTerm(alias).filter((Predicate<TermDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$compactObject$2(com.apicatalog.jsonld.context.TermDefinition ), (Lcom/apicatalog/jsonld/context/TermDefinition;)Z)()).isPresent() != false;
                LdAdapter.setOrAdd(result, alias, compactedValue, asArray);
                continue;
            }
            if ("@reverse".equals(expandedProperty)) {
                compactedMap = (Map)Compaction.with(activeContext, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact("@reverse", expandedValue);
                remaining = null;
                for (Map.Entry entry : compactedMap.entrySet()) {
                    if (activeContext.findTerm((String)entry.getKey()).filter((Predicate<TermDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isReverseProperty(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Z)()).isPresent()) {
                        asArray = this.compactArrays == false || activeContext.findTerm((String)entry.getKey()).filter((Predicate<TermDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$compactObject$3(com.apicatalog.jsonld.context.TermDefinition ), (Lcom/apicatalog/jsonld/context/TermDefinition;)Z)()).isPresent() != false;
                        LdAdapter.setOrAdd(result, (String)entry.getKey(), entry.getValue(), asArray);
                        continue;
                    }
                    if (remaining == null) {
                        remaining = new HashMap<String, V>();
                    }
                    remaining.put((String)entry.getKey(), entry.getValue());
                }
                if (remaining == null) continue;
                result.put(UriCompaction.withVocab(activeContext, "@reverse", this.options), remaining);
                continue;
            }
            if ("@preserve".equals(expandedProperty)) {
                compactedValue = Compaction.with(activeContext, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact(activeProperty, expandedValue);
                if (compactedValue instanceof Collection && (array = (Collection)compactedValue).isEmpty()) continue;
                result.put("@preserve", compactedValue);
                continue;
            }
            if ("@index".equals(expandedProperty) && activePropertyDefinition.filter((Predicate<TermDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$compactObject$4(com.apicatalog.jsonld.context.TermDefinition ), (Lcom/apicatalog/jsonld/context/TermDefinition;)Z)()).isPresent()) continue;
            if (Compaction.DILV_KEYWORDS.contains(expandedProperty)) {
                result.put(UriCompaction.withVocab(activeContext, expandedProperty, this.options), expandedValue);
                continue;
            }
            if (expandedValue instanceof Collection && (array = (Collection)expandedValue).isEmpty()) {
                itemActiveProperty = UriCompaction.withVocab(activeContext, expandedProperty, expandedValue, insideReverse, this.options);
                nestProperty = activeContext.findTerm(itemActiveProperty).map((Function<TermDefinition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNestValue(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Ljava/lang/String;)());
                if (nestProperty.isPresent()) {
                    nestTerm = nestProperty.get();
                    if (!"@nest".equals(nestTerm) && !"@nest".equals(UriExpansion.with(activeContext, this.options.loader(), this.runtime).vocab(true).expand(nestTerm))) {
                        throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_NEST_VALUE);
                    }
                    LdAdapter.setOrAdd((Map)result.computeIfAbsent(nestTerm, (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compactObject$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()), itemActiveProperty, List.of());
                } else {
                    LdAdapter.setOrAdd(result, itemActiveProperty, List.of());
                }
            }
            for (E expandedItem : (Collection)expandedValue) {
                block89: {
                    block91: {
                        block93: {
                            block92: {
                                block90: {
                                    block88: {
                                        itemActiveProperty = UriCompaction.withVocab(activeContext, expandedProperty, expandedItem, insideReverse, this.options);
                                        nestResult = null;
                                        nestResultKey = null;
                                        nestProperty = activeContext.findTerm(itemActiveProperty).map((Function<TermDefinition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getNestValue(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Ljava/lang/String;)());
                                        if (nestProperty.isPresent()) {
                                            nestTerm = nestProperty.get();
                                            if (!"@nest".equals(nestTerm) && !"@nest".equals(UriExpansion.with(activeContext, this.options.loader(), this.runtime).vocab(true).expand(nestTerm))) {
                                                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_KEYWORD_NEST_VALUE);
                                            }
                                            nestResult = (Map)result.computeIfAbsent(nestTerm, (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compactObject$6(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
                                            nestResultKey = nestTerm;
                                        } else {
                                            nestResult = result;
                                        }
                                        container = activeContext.findTerm(itemActiveProperty).map((Function<TermDefinition, Collection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getContainerMapping(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Ljava/util/Collection;)()).orElse(List.of());
                                        asArray = container.contains("@set") != false || "@graph".equals(itemActiveProperty) != false || "@list".equals(itemActiveProperty) != false || this.compactArrays == false;
                                        expandedItemValue /* !! */  = expandedItem;
                                        if (expandedItem instanceof Map) {
                                            map = (Map)expandedItem;
                                            if (LdAdapter.isList(map)) {
                                                expandedItemValue /* !! */  = map.get("@list");
                                            } else if (LdAdapter.isGraph(map)) {
                                                expandedItemValue /* !! */  = map.get("@graph");
                                            }
                                        }
                                        compactedItem /* !! */  = Compaction.with(activeContext, this.options, this.runtime).compactArrays(this.compactArrays).ordered(this.ordered).compact(itemActiveProperty, expandedItemValue /* !! */ );
                                        if (!(expandedItem instanceof Map) || !LdAdapter.isList(expandedItemMap = (Map)expandedItem)) break block88;
                                        compactedItem /* !! */  = NativeAdapter.asCollection((Object)compactedItem /* !! */ );
                                        if (!container.contains("@list")) {
                                            key = UriCompaction.withVocab(activeContext, "@list", this.options);
                                            if (expandedItemMap.containsKey("@index")) {
                                                indexKey = UriCompaction.withVocab(activeContext, "@index", this.options);
                                                compactedItem /* !! */  = Map.of(key, compactedItem /* !! */ , indexKey, expandedItemMap.get("@index"));
                                            } else {
                                                compactedItem /* !! */  = Map.of(key, compactedItem /* !! */ );
                                            }
                                            LdAdapter.setOrAdd(nestResult, itemActiveProperty, compactedItem /* !! */ , asArray);
                                        } else {
                                            nestResult.put(itemActiveProperty, compactedItem /* !! */ );
                                        }
                                        break block89;
                                    }
                                    if (!(expandedItem instanceof Map) || !LdAdapter.isGraph(expandedItemMap = (Map)expandedItem)) break block90;
                                    followup = false;
                                    if (container.contains("@graph") && container.contains("@id")) {
                                        mapKey = null;
                                        id = expandedItemMap.get("@id");
                                        if (id instanceof String) {
                                            idString = (String)id;
                                            mapKey = UriCompaction.compact(activeContext, idString, this.options);
                                        } else if (id == null) {
                                            mapKey = UriCompaction.withVocab(activeContext, "@none", this.options);
                                        } else {
                                            throw new IllegalStateException();
                                        }
                                        LdAdapter.setOrAdd((Map)nestResult.computeIfAbsent(itemActiveProperty, (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compactObject$7(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()), mapKey, compactedItem /* !! */ , asArray);
                                    } else if (container.contains("@graph") && container.contains("@index") && LdAdapter.isSimpleGraph(expandedItemMap)) {
                                        mapKey = expandedItemMap.containsKey("@index") != false ? (String)expandedItemMap.get("@index") : "@none";
                                        LdAdapter.setOrAdd((Map)nestResult.computeIfAbsent(itemActiveProperty, (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compactObject$8(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()), mapKey, compactedItem /* !! */ , asArray);
                                    } else if (container.contains("@graph") && LdAdapter.isSimpleGraph(expandedItemMap)) {
                                        if (compactedItem /* !! */  instanceof Collection && (array = (Collection)compactedItem /* !! */ ).size() > 1) {
                                            compactedItem /* !! */  = Map.of(UriCompaction.withVocab(activeContext, "@included", this.options), compactedItem /* !! */ );
                                        }
                                        LdAdapter.setOrAdd(nestResult, itemActiveProperty, compactedItem /* !! */ , asArray);
                                    } else {
                                        followup = true;
                                    }
                                    if (!container.contains("@graph") || followup) {
                                        compactedItemMap /* !! */  = expandedItemMap.containsKey("@id") != false ? Map.of(UriCompaction.withVocab(activeContext, "@graph", this.options), compactedItem /* !! */ , UriCompaction.withVocab(activeContext, "@id", this.options), UriCompaction.compact(activeContext, (String)expandedItemMap.get("@id"), this.options)) : Map.of(UriCompaction.withVocab(activeContext, "@graph", this.options), compactedItem /* !! */ );
                                        compactedItem /* !! */  = compactedItemMap /* !! */ ;
                                        if (expandedItemMap.containsKey("@index")) {
                                            map = new LinkedHashMap<String, Map<String, Object>>(compactedItemMap /* !! */ );
                                            map.put(UriCompaction.withVocab(activeContext, "@index", this.options), (Map<String, Object>)((String)expandedItemMap.get("@index")));
                                            compactedItem /* !! */  = map;
                                        }
                                        LdAdapter.setOrAdd(nestResult, itemActiveProperty, compactedItem /* !! */ , asArray);
                                    }
                                    break block89;
                                }
                                if (!container.contains("@language") && !container.contains("@index") && !container.contains("@id") && !container.contains("@type") || container.contains("@graph")) break block91;
                                keyToCompact = null;
                                if (container.contains("@language")) {
                                    keyToCompact = "@language";
                                } else if (container.contains("@index")) {
                                    keyToCompact = "@index";
                                } else if (container.contains("@id")) {
                                    keyToCompact = "@id";
                                } else if (container.contains("@type")) {
                                    keyToCompact = "@type";
                                }
                                containerKey = UriCompaction.withVocab(activeContext, keyToCompact, this.options);
                                indexKey = activeContext.findTerm(itemActiveProperty).map((Function<TermDefinition, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getIndexMapping(), (Lcom/apicatalog/jsonld/context/TermDefinition;)Ljava/lang/String;)()).orElse("@index");
                                mapKey = null;
                                if (!container.contains("@language") || !(expandedItem instanceof Map) || !(expandedItemMap = (Map)expandedItem).containsKey("@value")) break block92;
                                if (compactedItem /* !! */  instanceof Map) {
                                    compactedItemMap = compactedItem /* !! */ ;
                                    compactedItem /* !! */  = compactedItemMap.get("@value");
                                }
                                if (expandedItemMap.containsKey("@language")) {
                                    mapKey = (String)expandedItemMap.get("@language");
                                }
                                break block93;
                            }
                            if (!container.contains("@index") || !(expandedItem instanceof Map)) ** GOTO lbl-1000
                            expandedItemMap = (Map)expandedItem;
                            if ("@index".equals(indexKey)) {
                                if (expandedItemMap.containsKey("@index")) {
                                    mapKey = (String)expandedItemMap.get("@index");
                                }
                            } else if (container.contains("@index") && !"@index".equals(indexKey)) {
                                containerKey = UriCompaction.withVocab(activeContext, UriExpansion.with(activeContext, this.options.loader(), this.runtime).expand(indexKey), this.options);
                                if (compactedItem /* !! */  instanceof Map && (compactedItemMap = (Map)compactedItem /* !! */ ).containsKey(containerKey)) {
                                    containerValue = compactedItemMap.get(containerKey);
                                    if (containerValue instanceof String) {
                                        valueString = (String)containerValue;
                                        compactedItem /* !! */  = Compaction.removeKey(compactedItemMap, containerKey);
                                        mapKey = valueString;
                                    } else if (containerValue instanceof Collection && !(listValue = (Collection)containerValue).isEmpty()) {
                                        it = listValue.iterator();
                                        mapKey = (String)it.next();
                                        if (listValue.size() == 1) {
                                            compactedMap = new LinkedHashMap<K, V>(compactedItemMap);
                                            compactedMap.remove(containerKey);
                                            compactedItem /* !! */  = compactedMap;
                                        } else {
                                            if (listValue.size() == 2) {
                                                containerKeyValue /* !! */  = it.next();
                                            } else {
                                                list = new ArrayList<E>(listValue.size() - 1);
                                                it.forEachRemaining((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/lang/Object;)V)(list));
                                                containerKeyValue /* !! */  = list;
                                            }
                                            compactedItem /* !! */  = Compaction.replaceKey(compactedItemMap, containerKey, containerKeyValue /* !! */ );
                                        }
                                    }
                                }
                            } else if (container.contains("@id")) {
                                if (compactedItem /* !! */  instanceof Map && (map = compactedItem /* !! */ ).containsKey(containerKey)) {
                                    mapKey = (String)map.get(containerKey);
                                    compactedItem /* !! */  = Compaction.removeKey(map, containerKey);
                                }
                            } else if (container.contains("@type")) {
                                if (compactedItem /* !! */  instanceof Map && (map = (Map)compactedItem /* !! */ ).containsKey(containerKey)) {
                                    compactedKeyValue = map.get(containerKey);
                                    if (compactedKeyValue != null) {
                                        compactedKeyArray = NativeAdapter.asCollection(compactedKeyValue);
                                        it = compactedKeyArray.iterator();
                                        mapKey = (String)it.next();
                                        if (compactedKeyArray.size() > 1) {
                                            compactedKeyArrayValue = null;
                                            if (compactedKeyArray.size() == 2) {
                                                compactedKeyArrayValue = (ArrayList<E>)it.next();
                                            } else {
                                                list = new ArrayList<E>(compactedKeyArray.size() - 1);
                                                it.forEachRemaining((Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/lang/Object;)V)(list));
                                                compactedKeyArrayValue = list;
                                            }
                                            compactedItem /* !! */  = Compaction.replaceKey(map, containerKey, compactedKeyArrayValue);
                                        } else {
                                            compactedItem /* !! */  = Compaction.removeKey(map, containerKey);
                                        }
                                    } else {
                                        compactedItem /* !! */  = Compaction.removeKey(map, containerKey);
                                    }
                                }
                                if (compactedItem /* !! */  instanceof Map && (map = (Map)compactedItem /* !! */ ).size() == 1 && "@id".equals(expandedKey = UriExpansion.with(activeContext, this.options.loader(), this.runtime).vocab(true).expand((String)map.keySet().iterator().next()))) {
                                    compactedItem /* !! */  = Compaction.with(activeContext, this.options, this.runtime).compact(itemActiveProperty, Map.of("@id", ((Map)expandedItem).get("@id")));
                                }
                            }
                        }
                        if (mapKey == null) {
                            mapKey = UriCompaction.withVocab(activeContext, "@none", this.options);
                        }
                        LdAdapter.setOrAdd((Map)nestResult.computeIfAbsent(itemActiveProperty, (Function<String, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compactObject$9(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()), mapKey, compactedItem /* !! */ , asArray);
                        break block89;
                    }
                    LdAdapter.setOrAdd(nestResult, itemActiveProperty, compactedItem /* !! */ , asArray);
                }
                if (nestResult == null || nestResultKey == null) continue;
                result.put(nestResultKey, nestResult);
            }
        }
        return result;
    }

    private static Map<String, Object> removeKey(Map container, String key) {
        LinkedHashMap<String, Object> compactedMap = new LinkedHashMap<String, Object>(container);
        compactedMap.remove(key);
        return compactedMap;
    }

    private static Map<String, Object> replaceKey(Map container, String key, Object value) {
        LinkedHashMap<String, Object> compactedMap = new LinkedHashMap<String, Object>(container);
        compactedMap.put(key, value);
        return compactedMap;
    }

    private static /* synthetic */ Object lambda$compactObject$9(String k) {
        return new LinkedHashMap();
    }

    private static /* synthetic */ Object lambda$compactObject$8(String k) {
        return new LinkedHashMap();
    }

    private static /* synthetic */ Object lambda$compactObject$7(String k) {
        return new LinkedHashMap();
    }

    private static /* synthetic */ Object lambda$compactObject$6(String k) {
        return new LinkedHashMap();
    }

    private static /* synthetic */ Object lambda$compactObject$5(String k) {
        return new LinkedHashMap();
    }

    private static /* synthetic */ boolean lambda$compactObject$4(TermDefinition d) {
        return d.hasContainerMapping("@index");
    }

    private static /* synthetic */ boolean lambda$compactObject$3(TermDefinition td) {
        return td.hasContainerMapping("@set");
    }

    private static /* synthetic */ boolean lambda$compactObject$2(TermDefinition t) {
        return t.hasContainerMapping("@set");
    }

    private static /* synthetic */ boolean lambda$compactObject$1(TermDefinition d) {
        return d.hasContainerMapping("@list");
    }
}

