/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.media;

import com.apicatalog.web.http.HttpAlphabet;
import com.apicatalog.web.media.MediaType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.IntPredicate;

final class MediaTypeParser {
    private static final IntPredicate NAME_FIRST = ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    private static final IntPredicate NAME_CHARS = ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 33 || ch == 35 || ch == 36 || ch == 38 || ch == 45 || ch == 94 || ch == 95 || ch == 46 || ch == 43;

    private MediaTypeParser() {
    }

    public static MediaType parse(String mediaTypeString) {
        char[] input = mediaTypeString.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        State state = State.INIT;
        String type = null;
        String subtype = null;
        String paramName = null;
        int index = -1;
        block16: for (int i = 0; i < input.length; ++i) {
            char ch = input[i];
            switch (state) {
                case INIT: {
                    if (HttpAlphabet.WHITESPACE.test(ch)) continue block16;
                    if (NAME_FIRST.test(ch)) {
                        state = State.TYPE;
                        index = i;
                        continue block16;
                    }
                    return null;
                }
                case TYPE: {
                    if (NAME_CHARS.test(ch)) continue block16;
                    if (ch == '/') {
                        type = String.valueOf(input, index, i - index).strip();
                        state = State.SUBTYPE;
                        index = i + 1;
                        continue block16;
                    }
                    return null;
                }
                case SUBTYPE: {
                    if (i == index && NAME_FIRST.test(ch) || i > index && NAME_CHARS.test(ch)) continue block16;
                    if (ch == ';') {
                        subtype = String.valueOf(input, index, i - index).strip();
                        state = State.PARAM_NAME;
                        index = i + 1;
                        continue block16;
                    }
                    if (HttpAlphabet.WHITESPACE.test(ch)) {
                        subtype = String.valueOf(input, index, i - index).strip();
                        state = State.PARAMS;
                        continue block16;
                    }
                    return null;
                }
                case PARAMS: {
                    if (HttpAlphabet.WHITESPACE.test(ch)) continue block16;
                    if (ch != ';') {
                        return new MediaType(type, subtype, params);
                    }
                    state = State.PARAM_NAME;
                    index = i + 1;
                    continue block16;
                }
                case PARAM_NAME: {
                    if (ch == '=') {
                        paramName = String.valueOf(input, index, i - index).strip().toLowerCase();
                        state = State.PARAM_VALUE;
                        continue block16;
                    }
                    if (ch != ';') continue block16;
                    paramName = String.valueOf(input, index, i - index).strip().toLowerCase();
                    params.computeIfAbsent(paramName, p -> new ArrayList()).add(paramName);
                    index = i + 1;
                    continue block16;
                }
                case PARAM_VALUE: {
                    if (Character.isSpaceChar(ch) || ch == '\t') continue block16;
                    if (ch == '\"') {
                        index = i + 1;
                        state = State.STRING_VALUE;
                        continue block16;
                    }
                    index = i;
                    state = State.LITERAL_VALUE;
                    continue block16;
                }
                case LITERAL_VALUE: {
                    if (ch != ';') continue block16;
                    params.computeIfAbsent(paramName, p -> new ArrayList()).add(String.valueOf(input, index, i - index).strip());
                    index = i + 1;
                    paramName = null;
                    state = State.PARAM_NAME;
                    continue block16;
                }
                case STRING_VALUE: {
                    if (ch == '\"') {
                        params.computeIfAbsent(paramName, p -> new ArrayList()).add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        paramName = null;
                        state = State.PARAMS;
                        continue block16;
                    }
                    if (ch == '\\') {
                        state = State.ESCAPE;
                        continue block16;
                    }
                    stringBuilder.append(ch);
                    continue block16;
                }
                case ESCAPE: {
                    stringBuilder.append(ch);
                    state = State.STRING_VALUE;
                }
            }
        }
        switch (state) {
            case SUBTYPE: {
                if (index >= input.length) break;
                subtype = String.valueOf(input, index, input.length - index).strip().toLowerCase();
                break;
            }
            case PARAM_NAME: {
                if (index >= input.length) break;
                paramName = String.valueOf(input, index, input.length - index).strip().toLowerCase();
                break;
            }
            case LITERAL_VALUE: {
                if (index >= input.length) break;
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(String.valueOf(input, index, input.length - index).strip());
                paramName = null;
                break;
            }
        }
        if (paramName != null) {
            if (stringBuilder.length() > 0) {
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(stringBuilder.toString());
            } else {
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(paramName);
            }
        }
        if (type == null || subtype == null) {
            return null;
        }
        return new MediaType(type, subtype, params);
    }

    private static enum State {
        INIT,
        TYPE,
        SUBTYPE,
        PARAMS,
        PARAM_NAME,
        PARAM_VALUE,
        STRING_VALUE,
        LITERAL_VALUE,
        ESCAPE;

    }
}

