/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.link;

import com.apicatalog.web.link.LinkHeaderParser;
import com.apicatalog.web.media.MediaType;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public record Link(URI context, URI target, Set<String> relations, MediaType type, Map<String, List<Attribute>> attributeMap) {
    public Link {
        relations = relations != null ? relations : Set.of();
        attributeMap = attributeMap != null ? attributeMap : Map.of();
    }

    public static final Collection<Link> of(String linkHeader) {
        return Link.of(linkHeader, null);
    }

    public static final Collection<Link> of(String linkHeader, URI baseUri) {
        return new LinkHeaderParser(baseUri).parse(Objects.requireNonNull(linkHeader));
    }

    public List<Attribute> attributes(String attributeName) {
        return this.attributeMap.containsKey(attributeName) ? this.attributeMap.get(attributeName) : List.of();
    }

    public List<Attribute> attributes() {
        return this.attributeMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<Attribute> findFirstAttribute(String attributeName) {
        return Optional.ofNullable(this.attributeMap.get(attributeName)).map(attrs -> (Attribute)attrs.get(0));
    }

    public Set<String> attributeNames() {
        return this.attributeMap.keySet();
    }

    public record Attribute(String name, String value, String languageTag) {
        public Attribute(String name) {
            this(name, name, null);
        }

        public Attribute(String name, String value) {
            this(name, value, null);
        }

        public Attribute {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
        }

        @Override
        public String toString() {
            if (this.value == null) {
                return this.name;
            }
            StringBuilder builder = new StringBuilder().append(this.name).append('=');
            if (this.languageTag != null) {
                builder.append(Charset.defaultCharset().name()).append('\'').append(this.languageTag).append('\'');
            }
            return builder.append(this.value).toString();
        }
    }
}

