/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.web.lang;

import com.apicatalog.web.lang.LanguageTagParser;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record LanguageTag(String language, Collection<String> languageExtensions, String script, String region, Collection<Extension> extensions, Collection<String> variants, Collection<String> privateUse) {
    public LanguageTag {
        languageExtensions = languageExtensions == null ? List.of() : List.copyOf(languageExtensions);
        extensions = extensions == null ? List.of() : List.copyOf(extensions);
        variants = variants == null ? List.of() : List.copyOf(variants);
        privateUse = privateUse == null ? List.of() : List.copyOf(privateUse);
    }

    public static boolean isWellFormed(String languageTag) {
        return LanguageTagParser.isWellFormed(Objects.requireNonNull(languageTag, "The parameter 'laguageTag' must not be null"));
    }

    public static LanguageTag of(String languageTag) {
        return LanguageTagParser.create(Objects.requireNonNull(languageTag, "The parameter 'laguageTag' must not be null")).parse();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.language);
        if (!this.languageExtensions.isEmpty()) {
            this.languageExtensions.forEach(tag -> sb.append('-').append((String)tag));
        }
        if (this.script != null) {
            sb.append('-').append(this.script);
        }
        if (this.region != null) {
            sb.append('-').append(this.region);
        }
        if (!this.variants.isEmpty()) {
            this.variants.forEach(tag -> sb.append('-').append((String)tag));
        }
        if (!this.extensions.isEmpty()) {
            this.extensions.forEach(tag -> sb.append('-').append(tag));
        }
        if (!this.privateUse.isEmpty()) {
            sb.append('-').append('x');
            this.privateUse.forEach(tag -> sb.append('-').append((String)tag));
        }
        return sb.toString();
    }

    public record Extension(char code, Collection<String> tags) {
        public Extension {
            Objects.requireNonNull(Character.valueOf(code), "The parameter 'code' must not be null");
            tags = List.copyOf(Objects.requireNonNull(tags, "The parameter 'tags' must not be null"));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder().append(this.code);
            this.tags.forEach(tag -> sb.append('-').append((String)tag));
            return sb.toString();
        }
    }
}

