/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.tordf;

import com.apicatalog.jcs.Jcs;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LdAdapter;
import com.apicatalog.jsonld.tordf.RdfQuadEmitter;
import com.apicatalog.jsonld.tordf.RdfTripleConsumer;
import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeIOException;
import com.apicatalog.tree.io.java.NativeAdapter;
import com.apicatalog.web.lang.LanguageTag;
import com.apicatalog.web.uri.UriUtils;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class JsonLdToQuads {
    public static final RdfJsonLiteralWriter JCS = Jcs::canonize;
    private static final Logger LOGGER = Logger.getLogger(JsonLdToQuads.class.getName());
    private static final DecimalFormat xsdDecimalFormat = new DecimalFormat("0.0##############E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private final NodeMap nodeMap;
    private boolean produceGeneralizedRdf;
    private RdfJsonLiteralWriter jsonWriter;
    private Options.RdfDirection rdfDirection;
    private UriValidationPolicy uriValidation;

    private JsonLdToQuads(NodeMap nodeMap) {
        this.nodeMap = nodeMap;
        this.produceGeneralizedRdf = false;
        this.jsonWriter = JCS;
        this.rdfDirection = null;
        this.uriValidation = Options.DEFAULT_URI_VALIDATION;
    }

    public static final JsonLdToQuads with(NodeMap nodeMap) {
        return new JsonLdToQuads(nodeMap);
    }

    public void provide(RdfQuadConsumer consumer) throws JsonLdException {
        try {
            this.provide(RdfQuadEmitter.newEmitter(consumer));
        }
        catch (RdfConsumerException e) {
            if (e.getCause() instanceof JsonLdException) {
                throw (JsonLdException)e.getCause();
            }
            throw new JsonLdException(JsonLdException.ErrorCode.UNSPECIFIED, (Throwable)e);
        }
    }

    public JsonLdToQuads produceGeneralizedRdf(boolean enable) {
        this.produceGeneralizedRdf = enable;
        return this;
    }

    public JsonLdToQuads rdfDirection(Options.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public JsonLdToQuads rdfJsonLiteralWriter(RdfJsonLiteralWriter jsonWriter) {
        this.jsonWriter = jsonWriter;
        return this;
    }

    public JsonLdToQuads uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    protected void provide(RdfTripleConsumer consumer) throws JsonLdException, RdfConsumerException {
        Iterator graphNames = this.nodeMap.graphs().stream().sorted().iterator();
        while (graphNames.hasNext()) {
            String graphName = (String)graphNames.next();
            if ("@default".equals(graphName)) {
                consumer.defaultGraph();
            } else if (BlankNode.isWellFormed(graphName)) {
                consumer.namedGraph(graphName);
            } else {
                if (!UriUtils.isAbsoluteUri(graphName, this.uriValidation)) continue;
                consumer.namedGraph(graphName);
            }
            Iterator subjects = this.nodeMap.subjects(graphName).stream().sorted().iterator();
            while (subjects.hasNext()) {
                String subject = (String)subjects.next();
                if (!BlankNode.isWellFormed(subject) && UriUtils.isNotAbsoluteUri(subject, this.uriValidation)) {
                    LOGGER.log(Level.WARNING, "Non well-formed subject [{0}] has been skipped.", subject);
                    continue;
                }
                Iterator properties = this.nodeMap.properties(graphName, subject).stream().sorted().iterator();
                while (properties.hasNext()) {
                    String property = (String)properties.next();
                    if ("@type".equals(property)) {
                        for (Object type : (Collection)this.nodeMap.get(graphName, subject, property)) {
                            String typeString;
                            if (!(type instanceof String) || !BlankNode.isWellFormed(typeString = (String)type) && UriUtils.isNotAbsoluteUri(typeString, this.uriValidation)) continue;
                            consumer.triple(subject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", typeString);
                        }
                        continue;
                    }
                    if (Keywords.contains(property) || (!BlankNode.isWellFormed(property) || this.produceGeneralizedRdf) && UriUtils.isNotAbsoluteUri(property, this.uriValidation)) continue;
                    Collection items = (Collection)this.nodeMap.get(graphName, subject, property);
                    for (Map item : items) {
                        this.fromObject(consumer, item, subject, property);
                    }
                }
            }
        }
    }

    private void fromObject(RdfTripleConsumer consumer, Map<String, ?> item, String subject, String predicate) throws JsonLdException, RdfConsumerException {
        String langString;
        String type;
        String datatype;
        if (LdAdapter.isNode(item)) {
            String idString;
            Object obj = item.get("@id");
            if (obj instanceof String && (BlankNode.isWellFormed(idString = (String)obj) || UriUtils.isAbsoluteUri(idString, this.uriValidation))) {
                consumer.triple(subject, predicate, idString);
            }
            return;
        }
        if (LdAdapter.isList(item)) {
            Collection list = (Collection)item.get("@list");
            this.fromList(consumer, list, subject, predicate);
        }
        if (!LdAdapter.isValueNode(item)) {
            return;
        }
        Object value = item.get("@value");
        Object obj = item.get("@type");
        String string = datatype = obj instanceof String ? (type = (String)obj) : null;
        if (datatype != null && !"@json".equals(datatype) && !UriUtils.isAbsoluteUri(datatype, this.uriValidation)) {
            LOGGER.log(Level.WARNING, "Datatype [{0}] is not an absolute IRI nor @json and value is skipped.", datatype);
            return;
        }
        if (!(!item.containsKey("@language") || (obj = item.get("@language")) instanceof String && LanguageTag.isWellFormed(langString = (String)obj))) {
            LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed string and value is skipped.", item.get("@language"));
            return;
        }
        String valueString = null;
        if ("@json".equals(datatype)) {
            try {
                if (value instanceof TreeIO) {
                    TreeIO node = (TreeIO)value;
                    valueString = this.jsonWriter.write(node.node(), node.adapter());
                } else {
                    valueString = this.jsonWriter.write(value, (TreeAdapter)NativeAdapter.instance());
                }
            }
            catch (TreeIOException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_JSON_LITERAL, (Throwable)e);
            }
            datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON";
        } else if (Boolean.TRUE.equals(value)) {
            valueString = "true";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (Boolean.FALSE.equals(value)) {
            valueString = "false";
            if (datatype == null) {
                datatype = "http://www.w3.org/2001/XMLSchema#boolean";
            }
        } else if (value instanceof Number) {
            BigDecimal decimal;
            Number number = (Number)value;
            if ("http://www.w3.org/2001/XMLSchema#double".equals(datatype) || "http://www.w3.org/2001/XMLSchema#float".equals(datatype) || !NativeAdapter.instance().isIntegral((Object)number) && number.doubleValue() % -1.0 != 0.0 || number instanceof BigDecimal && (decimal = (BigDecimal)number).compareTo(BigDecimal.ONE.movePointRight(21)) >= 0) {
                valueString = JsonLdToQuads.toXsdDouble(number.doubleValue());
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#double";
                }
            } else {
                valueString = Long.toString(number.longValue());
                if (datatype == null) {
                    datatype = "http://www.w3.org/2001/XMLSchema#integer";
                }
            }
        } else if (datatype == null) {
            String string2 = datatype = item.containsKey("@language") ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string";
        }
        if (valueString == null) {
            if (value instanceof String) {
                String valueAsString;
                valueString = valueAsString = (String)value;
            } else {
                return;
            }
        }
        if (item.containsKey("@direction") && this.rdfDirection != null) {
            String language;
            Object obj2 = item.get("@language");
            if (obj2 instanceof String) {
                String langString2 = (String)obj2;
                v2 = langString2.toLowerCase();
            } else {
                v2 = language = "";
            }
            if (Options.RdfDirection.I18N_DATATYPE == this.rdfDirection) {
                consumer.triple(subject, predicate, valueString, language, (String)item.get("@direction"));
            } else if (Options.RdfDirection.COMPOUND_LITERAL == this.rdfDirection) {
                String blankNodeId = this.nodeMap.createIdentifier();
                consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#value", valueString, "http://www.w3.org/2001/XMLSchema#string");
                Object obj3 = item.get("@language");
                if (obj3 instanceof String) {
                    String langString3 = (String)obj3;
                    consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#language", langString3.toLowerCase(), "http://www.w3.org/2001/XMLSchema#string");
                }
                consumer.triple(blankNodeId, "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction", (String)item.get("@direction"), "http://www.w3.org/2001/XMLSchema#string");
                consumer.triple(subject, predicate, blankNodeId);
                return;
            }
        } else {
            Object obj4 = item.get("@language");
            if (obj4 instanceof String) {
                String langString4 = (String)obj4;
                consumer.triple(subject, predicate, valueString, langString4, null);
            } else {
                consumer.triple(subject, predicate, valueString, datatype);
            }
        }
    }

    private void fromList(RdfTripleConsumer consumer, Collection<Map<String, Object>> list, String subject, String predicate) throws JsonLdException, RdfConsumerException {
        if (list.isEmpty()) {
            consumer.triple(subject, predicate, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            return;
        }
        String[] bnodes = new String[list.size()];
        for (int i = 0; i < bnodes.length; ++i) {
            bnodes[i] = this.nodeMap.createIdentifier();
        }
        consumer.triple(subject, predicate, bnodes[0]);
        int index = 0;
        for (Map<String, Object> item : list) {
            String blankNodeSubject = bnodes[index];
            this.fromObject(consumer, item, blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
            if (++index < bnodes.length) {
                consumer.triple(blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", bnodes[index]);
                continue;
            }
            consumer.triple(blankNodeSubject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        }
    }

    private static final String toXsdDouble(double number) {
        return xsdDecimalFormat.format(number);
    }

    static {
        xsdDecimalFormat.setMinimumFractionDigits(1);
    }

    @FunctionalInterface
    public static interface RdfJsonLiteralWriter {
        public String write(Object var1, TreeAdapter var2) throws JsonLdException, TreeIOException;
    }
}

