/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.flattening.Flattening;
import com.apicatalog.jsonld.processor.Compactor;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.jsonld.processor.Expander;
import com.apicatalog.tree.io.TreeIO;
import java.net.URI;
import java.util.Collection;
import java.util.Map;

public final class Flattener {
    private Flattener() {
    }

    public static Object flatten(Document document, TreeIO context, Options options, Execution runtime) throws JsonLdException {
        Options expansionOptions = Options.copyOf(options).ordered(false);
        Collection<?> expandedInput = Expander.expand(document, expansionOptions, runtime);
        return Flattener.flatten(expandedInput, document.url(), context, options, runtime);
    }

    public static Object flatten(TreeIO document, TreeIO context, Options options, Execution runtime) throws JsonLdException {
        Options expansionOptions = Options.copyOf(options).ordered(false);
        Collection<?> expandedInput = Expander.expand(document, Expander.context(null, null, options, runtime), null, expansionOptions, runtime);
        return Flattener.flatten(expandedInput, null, context, options, runtime);
    }

    static final Object flatten(Collection<?> expandedInput, URI documentUrl, TreeIO context, Options options, Execution runtime) throws JsonLdException {
        Map<String, ?> flattenedOutput = Flattening.flatten(expandedInput, options.isOrdered());
        if (context != null) {
            Options compactionOptions = Options.copyOf(options);
            if (options.base() != null) {
                compactionOptions.base(options.base());
            } else if (options.isCompactArrays() && documentUrl != null) {
                compactionOptions.base(documentUrl);
            }
            flattenedOutput = Compactor.compact((Object)flattenedOutput, documentUrl, context, compactionOptions, runtime);
        }
        return flattenedOutput;
    }
}

