/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.Options;
import com.apicatalog.jsonld.context.Context;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Expander {
    public static final Collection<?> expand(Document document, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(document.content(), Expander.context(document.url(), document.context(), options, runtime), Expander.baseUrl(document.url(), options), options, runtime);
    }

    public static final Collection<?> expand(TreeIO document, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(document, Expander.context(null, null, options, runtime), Expander.baseUrl(null, options), options, runtime);
    }

    public static final Collection<?> expand(TreeIO node, Context context, URI baseUrl, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(node, context, baseUrl, false, options, runtime);
    }

    public static final Collection<?> expandFrame(Document document, Options options, Execution runtime) throws JsonLdException {
        return Expander.expandFrame(document.content(), Expander.context(document.url(), document.context(), options, runtime), Expander.baseUrl(document.url(), options), options, runtime);
    }

    public static final Collection<?> expandFrame(TreeIO node, Context context, URI baseUrl, Options options, Execution runtime) throws JsonLdException {
        return Expander.expand(node, context, baseUrl, true, options, runtime);
    }

    public static final Context context(URI document, URI context, Options options, Execution runtime) throws JsonLdException {
        URI baseUrl = Expander.baseUrl(document, options);
        URI baseUri = document;
        if (options.base() != null) {
            baseUri = options.base();
        }
        Context.Builder builder = new Context.Builder(baseUri, baseUrl, options.mode()).runtime(runtime).loader(options.loader());
        if (options.expandContext() != null) {
            TreeIO expandContext = options.expandContext().content();
            builder.update(Expander.extractExpansionContext(expandContext), expandContext.adapter(), baseUrl);
        }
        if (context != null) {
            builder.update(context.toString(), (TreeAdapter)NativeAdapter.instance(), context);
        }
        return builder.build();
    }

    public static final URI baseUrl(URI document, Options options) {
        return document != null ? document : options.base();
    }

    private static final Collection<?> expand(TreeIO node, Context context, URI baseUrl, boolean frameExpansion, Options options, Execution runtime) throws JsonLdException {
        Map map;
        Object expanded = Expansion.expand(context, node.node(), node.adapter(), null, new Expansion.Params(frameExpansion, false, baseUrl, options, runtime));
        if (expanded instanceof Map && (map = (Map)expanded).size() == 1 && map.containsKey("@graph")) {
            expanded = map.get("@graph");
        }
        if (expanded == null) {
            return Set.of();
        }
        if (expanded instanceof Collection) {
            Collection collection = (Collection)expanded;
            return List.copyOf(collection);
        }
        return Set.of(expanded);
    }

    private static Object extractExpansionContext(TreeIO context) throws JsonLdException {
        Objects.requireNonNull(context, "context must not be null");
        if (context.isCollection()) {
            if (context.isSingleElement()) {
                Object element = context.singleElement();
                TreeAdapter adapter = context.adapter();
                if (adapter.isMap(element) && adapter.keys(element).contains("@context")) {
                    return adapter.property((Object)"@context", element);
                }
            }
            return context.node();
        }
        if (context.isMap() && context.keys().contains("@context")) {
            return context.property("@context");
        }
        return context.node();
    }
}

