/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class SchemeRouter
implements DocumentLoader {
    private final Map<String, DocumentLoader> loaders;
    private final DocumentLoader fallback;

    private SchemeRouter(Map<String, DocumentLoader> loaders, DocumentLoader fallback) {
        this.loaders = loaders;
        this.fallback = fallback;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        DocumentLoader loader = this.loaders.getOrDefault(Objects.requireNonNull(url, "The url must not be null.").getScheme().toLowerCase(), null);
        if (loader != null) {
            return loader.loadDocument(url, options);
        }
        if (this.fallback != null) {
            return this.fallback.loadDocument(url, options);
        }
        throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "URL scheme [" + url.getScheme() + "] is not supported.");
    }

    public static final class Builder {
        private final Map<String, DocumentLoader> routes = new LinkedHashMap<String, DocumentLoader>();
        private DocumentLoader fallback;

        public Builder route(String scheme, DocumentLoader loader) {
            this.routes.put(scheme.toLowerCase(), loader);
            return this;
        }

        public Builder fallback(DocumentLoader loader) {
            this.fallback = loader;
            return this;
        }

        public DocumentLoader build() {
            return new SchemeRouter(Map.copyOf(this.routes), this.fallback);
        }
    }
}

