/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.HttpLoaderClient;
import com.apicatalog.jsonld.loader.NativeHttpClient;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeParser;
import com.apicatalog.web.link.Link;
import com.apicatalog.web.media.MediaType;
import com.apicatalog.web.uri.UriResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HttpLoader
implements DocumentLoader {
    private static final Logger LOGGER = Logger.getLogger(HttpLoader.class.getName());
    private static final String PLUS_JSON = "+json";
    public static final Predicate<MediaType> DEFAULT_JSON_LD_CONTENT = contentType -> contentType != null && (MediaType.JSON_LD.match((MediaType)contentType) || MediaType.JSON.match((MediaType)contentType) || contentType.subtype().toLowerCase().endsWith(PLUS_JSON));
    public static final Collection<Map.Entry<String, String>> VENDOR_HEADERS = List.of(Map.entry("User-Agent", "titanium-json-ld/2 (+https://github.com/filip26/titanium-json-ld)"));
    public static final int MAX_REDIRECTIONS = 10;
    private final int maxRedirections;
    private final HttpLoaderClient client;
    private final TreeParser reader;
    private Predicate<MediaType> acceptContent;

    protected HttpLoader(HttpLoaderClient httpClient, TreeParser reader, int maxRedirections) {
        this.client = httpClient;
        this.maxRedirections = maxRedirections;
        this.reader = reader;
        this.acceptContent = DEFAULT_JSON_LD_CONTENT;
    }

    public static HttpLoader newLoader(TreeParser parser) {
        return HttpLoader.newLoader(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build(), parser).headers(VENDOR_HEADERS);
    }

    public static HttpLoader newLoader(HttpClient client, TreeParser reader) {
        return new HttpLoader(new NativeHttpClient(client), reader, 10).headers(VENDOR_HEADERS);
    }

    public static HttpLoader newLoader(HttpClient client, TreeParser reader, int maxRedirections) {
        return new HttpLoader(new NativeHttpClient(client), reader, maxRedirections).headers(VENDOR_HEADERS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        try {
            URI targetUri = url;
            MediaType contentType = null;
            URI contextUri = null;
            int redirection = 0;
            while (redirection < this.maxRedirections) {
                block22: {
                    try (HttpLoaderClient.Response response = this.client.send(targetUri, options.requestProfile());){
                        if (response.statusCode() == 301 || response.statusCode() == 302 || response.statusCode() == 303 || response.statusCode() == 307) {
                            Optional<String> location = response.location();
                            if (!location.isPresent()) throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Header location is required for code [" + response.statusCode() + "].");
                            targetUri = UriResolver.resolveAsUri(targetUri, location.get());
                            break block22;
                        }
                        if (response.statusCode() != 200) {
                            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Unexpected response code [" + response.statusCode() + "] for URL [" + String.valueOf(url) + "].");
                        }
                        contentType = response.contentType().map(MediaType::of).orElse(null);
                        Collection<String> linkValues = response.links();
                        if (linkValues != null && !linkValues.isEmpty()) {
                            URI baseUri;
                            if (contentType == null || !MediaType.JSON.match(contentType) && !contentType.subtype().toLowerCase().endsWith(PLUS_JSON)) {
                                baseUri = targetUri;
                                Optional<Link> alternate = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("alternate") && MediaType.JSON_LD.match(l.type())).findFirst();
                                if (alternate.isPresent()) {
                                    targetUri = alternate.get().target();
                                    break block22;
                                }
                            }
                            if (contentType != null && !MediaType.JSON_LD.match(contentType) && (MediaType.JSON.match(contentType) || contentType.subtype().toLowerCase().endsWith(PLUS_JSON))) {
                                baseUri = targetUri;
                                List contextUris = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("http://www.w3.org/ns/json-ld#context")).collect(Collectors.toList());
                                if (contextUris.size() > 1) {
                                    throw new JsonLdException(JsonLdException.ErrorCode.MULTIPLE_CONTEXT_LINK_HEADERS);
                                }
                                if (contextUris.size() == 1) {
                                    contextUri = ((Link)contextUris.get(0)).target();
                                }
                            }
                        }
                        if (contentType == null) {
                            LOGGER.log(Level.WARNING, "GET on URL [{0}] does not return content-type header.", url);
                        } else if (!this.acceptContent.test(contentType)) {
                            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported content-type '" + String.valueOf(contentType) + "'.");
                        }
                        Document document = this.read(contentType, targetUri, contextUri, response);
                        return document;
                    }
                }
                ++redirection;
            }
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Too many redirections");
        }
        catch (IOException e) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
    }

    private final Document read(MediaType contentType, URI targetUri, URI contextUrl, HttpLoaderClient.Response response) throws JsonLdException {
        Document document;
        block8: {
            InputStream is = response.body();
            try {
                TreeIO content = this.reader.parse(is);
                document = Document.of(content, contentType, targetUri, contextUrl);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
                }
            }
            is.close();
        }
        return document;
    }

    public HttpLoader timeout(Duration timeout) {
        this.client.timeout(timeout);
        return this;
    }

    public HttpLoader headers(Collection<Map.Entry<String, String>> headers) {
        this.client.headers(headers);
        return this;
    }

    public HttpLoader accept(Predicate<MediaType> predicate) {
        this.acceptContent = Objects.requireNonNull(predicate, "predicate must not be null");
        return this;
    }

    public static final String acceptHeader() {
        return HttpLoader.acceptHeader(List.of());
    }

    public static final String acceptHeader(Collection<String> profiles) {
        StringBuilder builder = new StringBuilder().append(MediaType.JSON_LD.toString());
        if (profiles != null && !profiles.isEmpty()) {
            builder.append(";profile=\"").append(String.join((CharSequence)" ", profiles)).append("\"");
        }
        return builder.append(',').append(MediaType.JSON.toString()).append(";q=0.9,*/*;q=0.1").toString();
    }
}

