/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.TreeParser;
import com.apicatalog.web.media.MediaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class FileLoader
implements DocumentLoader {
    private static final Map<String, MediaType> FILE_EXTENSIONS = Map.of(".jsonld", MediaType.JSON_LD, ".json", MediaType.JSON, ".html", MediaType.HTML, ".xhtml", MediaType.XHTML, ".nq", MediaType.N_QUADS, ".cbor", MediaType.CBOR, ".cborld", MediaType.CBOR_LD, ".yml", MediaType.YAML, ".yaml", MediaType.YAML, ".yamlld", MediaType.YAML_LD);
    private final TreeParser reader;

    public FileLoader(TreeParser reader) {
        this.reader = reader;
    }

    @Override
    public Document loadDocument(URI url, DocumentLoader.Options options) throws JsonLdException {
        Document document;
        if (!"file".equalsIgnoreCase(url.getScheme())) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Unsupported URL scheme [" + url.getScheme() + "]. FileLoader accepts only file scheme.");
        }
        File file = new File(url);
        if (!file.canRead()) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "File [" + String.valueOf(url) + "] is not accessible to read.");
        }
        MediaType contentType = FileLoader.fromFileExtension(file.getName());
        FileInputStream is = new FileInputStream(file);
        try {
            TreeIO node = this.reader.parse((InputStream)is);
            document = Document.of(node, contentType, url);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "File not found [" + String.valueOf(url) + "].");
            }
            catch (Exception e) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
            }
        }
        is.close();
        return document;
    }

    static final MediaType fromFileExtension(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        String lower = name.toLowerCase();
        return FILE_EXTENSIONS.entrySet().stream().filter(e -> lower.endsWith((String)e.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }
}

