/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.web.uri.UriUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LdAdapter {
    private static final Set<String> GRAPH_ALLOWED_KEYS = Set.of("@graph", "@id", "@index", "@context");
    private static final Collection<String> VALUE_KEYWORDS = Arrays.asList("@type", "@value", "@direction", "@language", "@index", "@annotation");

    public static final boolean isNode(Object node) {
        Map map;
        return node instanceof Map && (!(map = (Map)node).containsKey("@value") && !map.containsKey("@list") && !map.containsKey("@set") || Arrays.asList("@context", "@graph").containsAll(map.keySet()));
    }

    public static boolean isNode(Object value, TreeAdapter adapter) {
        if (!adapter.isMap(value)) {
            return false;
        }
        return adapter.keyStream(value).noneMatch(Set.of("@value", "@list", "@set")::contains) || Set.of("@context", "@graph").containsAll(adapter.keys(value));
    }

    public static final boolean isReference(Object node) {
        Map map;
        return node instanceof Map && (map = (Map)node).size() == 1 && map.containsKey("@id");
    }

    public static final boolean isGraph(Object node) {
        Map map;
        return node instanceof Map && (map = (Map)node).containsKey("@graph") && GRAPH_ALLOWED_KEYS.containsAll(map.keySet());
    }

    public static final boolean isSimpleGraph(Map<?, ?> node) {
        return LdAdapter.isGraph(node) && !node.containsKey("@id");
    }

    public static boolean isNotGraph(Object node) {
        Map map;
        return node == null || !(node instanceof Map) || !(map = (Map)node).keySet().contains("@graph") || !GRAPH_ALLOWED_KEYS.containsAll(map.keySet());
    }

    public static boolean isDefault(Object node) {
        Map map;
        return node instanceof Map && (map = (Map)node).keySet().contains("@default");
    }

    public static boolean isDefault(Object node, TreeAdapter adapter) {
        return adapter.isMap(node) && adapter.keys(node).contains("@default");
    }

    public static Optional<?> findDefaultValue(Object node, TreeAdapter adapter) {
        return adapter.isMap(node) ? Optional.ofNullable(adapter.property((Object)"@default", node)) : Optional.empty();
    }

    public static boolean isList(Map<?, ?> node) {
        return node.containsKey("@list") && (node.size() == 1 || node.size() == 2 && node.containsKey("@index"));
    }

    public static Map<String, ?> toList(Object node) {
        return node instanceof Collection ? Map.of("@list", node) : Map.of("@list", Set.of(node));
    }

    public static boolean isValueNode(Map<?, ?> node) {
        return node.containsKey("@value");
    }

    public static boolean isNotValueNode(Object node) {
        Map map;
        return !(node instanceof Map && VALUE_KEYWORDS.containsAll((map = (Map)node).keySet()));
    }

    public static Optional<Object> findValue(Object node) {
        Optional<Object> optional;
        if (node instanceof Map) {
            Map map = (Map)node;
            optional = Optional.ofNullable(map.get("@value"));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public static void setOrAdd(Map<String, Object> result, String key, Object value) {
        LdAdapter.setOrAdd(result, key, value, true);
    }

    public static void setOrAdd(Map<String, Object> source, String key, Object value, boolean asArray) {
        ArrayList<Object> array;
        Object previous = source.get(key);
        if (previous == null) {
            if (value instanceof Collection) {
                Collection array2 = (Collection)value;
                if (!asArray && array2.size() == 1) {
                    source.put(key, array2.iterator().next());
                    return;
                }
                source.put(key, value);
                return;
            }
            if (asArray) {
                if (value == null) {
                    source.put(key, List.of());
                    return;
                }
                source.put(key, List.of(value));
                return;
            }
            source.put(key, value);
            return;
        }
        if (previous instanceof ArrayList) {
            ArrayList<Object> list;
            ArrayList<Object> typedList = list = (ArrayList<Object>)previous;
            if (!asArray && typedList.isEmpty()) {
                Collection single;
                if (value instanceof Collection && (single = (Collection)value).size() == 1) {
                    source.put(key, single.iterator().next());
                    return;
                }
                source.put(key, value);
                return;
            }
            array = typedList;
        } else if (previous instanceof Collection) {
            Collection col = (Collection)previous;
            if (!asArray && col.isEmpty()) {
                Collection single;
                if (value instanceof Collection && (single = (Collection)value).size() == 1) {
                    source.put(key, single.iterator().next());
                    return;
                }
                source.put(key, value);
                return;
            }
            array = new ArrayList<Object>(col);
            source.put(key, array);
        } else {
            array = new ArrayList<Object>();
            array.add(previous);
            source.put(key, array);
        }
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            array.addAll(col);
        } else {
            array.add(value);
        }
    }

    public static final boolean isAnnotation(Object node) {
        if (node instanceof Collection) {
            Collection array = (Collection)node;
            for (Object element : array) {
                if (LdAdapter.isAnnotation(element)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof Map) {
            Map map = (Map)node;
            for (Map.Entry entry : map.entrySet()) {
                String key;
                Object k = entry.getKey();
                if (k instanceof String && (!"@annotation".equals(key = (String)k) || LdAdapter.isAnnotation(entry.getValue())) && (!Keywords.matchForm(key) || "@type".equals(key) || "@reverse".equals(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmbedded(Object node) {
        if (node instanceof Map) {
            Map map = (Map)node;
            boolean found = false;
            for (Map.Entry entry : map.entrySet()) {
                String key;
                Object k;
                if (entry.getKey().equals("@index") || entry.getKey().equals("@context") || entry.getKey().equals("@reverse")) {
                    return false;
                }
                if (!"@type".equals(entry.getKey()) && (k = entry.getKey()) instanceof String && Keywords.matchForm(key = (String)k)) continue;
                if (!found && ("@type".equals(entry.getKey()) || (k = entry.getKey()) instanceof String && UriUtils.isURI(key = (String)k))) {
                    Map valueMap;
                    Object propertyValue = entry.getValue();
                    if (propertyValue instanceof Collection) {
                        Collection array = (Collection)propertyValue;
                        if (array.size() != 1) {
                            return false;
                        }
                        propertyValue = array.iterator().next();
                    }
                    if (propertyValue instanceof Map && LdAdapter.isValueNode(valueMap = (Map)propertyValue)) {
                        propertyValue = LdAdapter.findValue(valueMap).orElse(null);
                    }
                    if (propertyValue instanceof String || propertyValue instanceof Map && LdAdapter.isEmbedded(valueMap = (Map)propertyValue)) {
                        found = true;
                        continue;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

