/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.fromrdf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

final class GraphMap {
    private final Map<String, Map<String, Map<String, Object>>> index = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
    private final Map<String, Map<String, List<Reference>>> usages;

    public GraphMap() {
        this.index.put("@default", new LinkedHashMap());
        this.usages = new LinkedHashMap<String, Map<String, List<Reference>>>();
    }

    public boolean contains(String graphName, String subject) {
        return Optional.ofNullable(this.index.get(graphName)).map(graphs -> graphs.containsKey(subject)).orElse(false);
    }

    public void set(String graphName, String subject, String property, Object value) {
        this.index.computeIfAbsent(graphName, e -> new LinkedHashMap()).computeIfAbsent(subject, e -> new LinkedHashMap()).put(property, value);
    }

    public Optional<Map<String, Object>> get(String graphName, String subject) {
        return Optional.ofNullable(this.index.get(graphName)).map(graphs -> (Map)graphs.get(subject));
    }

    public Optional<Object> get(String graphName, String subject, String property) {
        return Optional.ofNullable(this.index.get(graphName)).map(graphs -> (Map)graphs.get(subject)).map(subjects -> subjects.get(property));
    }

    public Set<String> keys(String graphName) {
        return this.index.get(graphName).keySet();
    }

    public boolean contains(String graphName) {
        return this.index.containsKey(graphName);
    }

    public Set<String> keys() {
        return this.index.keySet();
    }

    public List<Reference> getUsages(String graphName, String subject) {
        return Optional.ofNullable(this.usages.get(graphName)).map(graphs -> (List)graphs.get(subject)).orElse(List.of());
    }

    public void addUsage(String graphName, String subject, Reference reference) {
        this.usages.computeIfAbsent(graphName, e -> new LinkedHashMap()).computeIfAbsent(subject, e -> new ArrayList()).add(reference);
    }

    public void remove(String graphName, String subject) {
        Optional.ofNullable(this.index.get(graphName)).ifPresent(graph -> graph.remove(subject));
    }

    public void clear() {
        this.index.clear();
        this.index.put("@default", new LinkedHashMap());
        this.usages.clear();
    }

    record Reference(String graphName, String subject, String property, Map<String, Object> value) {
    }
}

