/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class Flattening {
    public static Object flatten(Collection<?> elements, boolean ordered) throws JsonLdException {
        NodeMap nodeMap = new NodeMap();
        new NodeMapBuilder(elements, nodeMap).build();
        Map<String, Map<String, Object>> defaultGraph = nodeMap.find("@default").orElseThrow(IllegalStateException::new);
        Iterator namedGraphs = (ordered ? nodeMap.graphs().stream().sorted() : nodeMap.graphs().stream()).filter(Predicate.not("@default"::equals)).iterator();
        while (namedGraphs.hasNext()) {
            String graphName = (String)namedGraphs.next();
            Map<String, Map<String, Object>> graph = nodeMap.find(graphName).orElseThrow(IllegalStateException::new);
            if (!defaultGraph.containsKey(graphName)) {
                defaultGraph.put(graphName, Map.of("@id", graphName));
            }
            LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(defaultGraph.get(graphName));
            entry.put("@graph", Flattening.filter(graph, ordered).toList());
            defaultGraph.put(graphName, entry);
        }
        return Flattening.filter(defaultGraph, ordered).toList();
    }

    private static Stream<?> filter(Map<String, Map<String, Object>> nodeMap, boolean ordered) {
        return (ordered ? nodeMap.keySet().stream().sorted() : nodeMap.keySet().stream()).map(nodeMap::get).filter(node -> node != null && (node.size() != 1 || !node.containsKey("@id")));
    }
}

