/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class BlankNodeIdGenerator {
    public static final String PREFIX = "_:b";
    private final Map<String, String> map;
    private final String prefix;
    private int counter;

    public BlankNodeIdGenerator() {
        this(new HashMap<String, String>(), PREFIX, 0);
    }

    public BlankNodeIdGenerator(Map<String, String> map, String prefix, int counter) {
        this.map = new HashMap<String, String>(Objects.requireNonNull(map, "Identifier map cannot be null."));
        this.prefix = Objects.requireNonNull(prefix, "Prefix cannot be null.");
        this.counter = counter;
    }

    public String createIdentifier() {
        return this.prefix + this.counter++;
    }

    public String createIdentifier(String identifier) {
        if (identifier == null || identifier.isBlank()) {
            return this.createIdentifier();
        }
        return this.map.computeIfAbsent(identifier, k -> this.createIdentifier());
    }
}

