/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.lang.Direction;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class InverseContextBuilder {
    private final ActiveContext activeContext;

    private InverseContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static final InverseContextBuilder with(ActiveContext activeContext) {
        return new InverseContextBuilder(activeContext);
    }

    public InverseContext build() {
        InverseContext result = new InverseContext();
        String defaultLanguage = this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage().toLowerCase() : "@none";
        this.activeContext.getTerms().stream().filter(termName -> this.activeContext.findTerm((String)termName).map(TermDefinition::getUriMapping).isPresent()).sorted().forEach(termName -> this.processTerm((String)termName, result, this.activeContext.findTerm((String)termName).map(TermDefinition::getUriMapping).get(), defaultLanguage));
        return result;
    }

    private void processTerm(String termName, InverseContext result, String variableValue, String defaultLanguage) {
        String container = this.activeContext.findTerm(termName).map(TermDefinition::getContainerMapping).filter(collection -> !collection.isEmpty()).orElseGet(() -> Arrays.asList("@none")).stream().sorted().collect(Collectors.joining());
        result.setIfAbsent(variableValue, container, "@any", "@none", termName);
        if (this.activeContext.findTerm(termName).filter(TermDefinition::isReverseProperty).isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", "@reverse", termName);
            return;
        }
        Optional<String> typeMapping = this.activeContext.findTerm(termName).map(TermDefinition::getTypeMapping);
        if (typeMapping.filter("@none"::equals).isPresent()) {
            result.setIfAbsent(variableValue, container, "@language", "@any", termName).setIfAbsent(variableValue, container, "@type", "@any", termName);
            return;
        }
        if (typeMapping.isPresent()) {
            result.setIfAbsent(variableValue, container, "@type", typeMapping.get(), termName);
            return;
        }
        Optional<String> languageMapping = this.activeContext.findTerm(termName).map(TermDefinition::getLanguageMapping);
        Optional<Direction> directionMapping = this.activeContext.findTerm(termName).map(TermDefinition::getDirectionMapping);
        if (languageMapping.isPresent()) {
            String langDir;
            String language = languageMapping.get();
            if (directionMapping.isPresent()) {
                Direction direction = directionMapping.get();
                langDir = language != null ? (direction != Direction.NULL ? language.concat("_").concat(direction.name()).toLowerCase() : language.toLowerCase()) : (direction != Direction.NULL ? "_".concat(direction.name().toLowerCase()) : "@null");
            } else {
                langDir = language != null ? language.toLowerCase() : "@null";
            }
            result.setIfAbsent(variableValue, container, "@language", langDir, termName);
        } else if (directionMapping.isPresent()) {
            String direction = directionMapping.filter(d -> d != Direction.NULL).map(d -> "_".concat(d.name().toLowerCase())).orElse("@none");
            result.setIfAbsent(variableValue, container, "@language", direction, termName);
        } else {
            String langDir = this.activeContext.getDefaultBaseDirection() != null ? (this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage() : "").concat("_").concat(this.activeContext.getDefaultBaseDirection().name()).toLowerCase() : defaultLanguage;
            result.setIfAbsent(variableValue, container, "@language", langDir, termName).setIfAbsent(variableValue, container, "@language", "@none", termName).setIfAbsent(variableValue, container, "@type", "@none", termName);
        }
    }
}

