/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.ContextBuilder;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.context.TermDefinitionBuilder;
import com.apicatalog.jsonld.lang.Direction;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.processor.Execution;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.java.NativeAdapter;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface Context {
    default public boolean isV11() {
        return this.version() == null ? true : JsonLd.Version.V1_1 == this.version();
    }

    default public boolean isV10() {
        return this.version() == null ? false : JsonLd.Version.V1_0 == this.version();
    }

    public JsonLd.Version version();

    public Optional<TermDefinition> findTerm(String var1);

    public Direction getDefaultBaseDirection();

    public String getDefaultLanguage();

    public URI getBaseUri();

    public String getVocabularyMapping();

    public Context getPreviousContext();

    public TermDefinitionBuilder newTerm(Object var1, TreeAdapter var2, Map<String, Boolean> var3, DocumentLoader var4, Execution var5);

    public ContextBuilder newContext(DocumentLoader var1, Execution var2);

    public InverseContext getInverseContext();

    public void createInverseContext();

    public Optional<String> selectTerm(Collection<String> var1, String var2, Collection<String> var3, String var4);

    public boolean containsTerm(String var1);

    public Map<String, TermDefinition> getTermsMapping();

    public static TreeIO extract(TreeIO document) throws JsonLdException {
        Object node = document.node();
        TreeAdapter adapter = document.adapter();
        if (!adapter.isMap(node)) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_CONTEXT_ENTRY, "Document is not map but [" + String.valueOf(node) + "].");
        }
        Object context = adapter.property((Object)"@context", node);
        if (context != null) {
            return new TreeIO(context, adapter);
        }
        return new TreeIO(Map.of(), (TreeAdapter)NativeAdapter.instance());
    }

    public static TreeIO unwrap(TreeIO context) {
        Object ctx;
        Object node = context.node();
        TreeAdapter adapter = context.adapter();
        boolean changed = false;
        if (adapter.isSingleElement(node)) {
            node = adapter.singleElement(node);
            changed = true;
        }
        if (adapter.isMap(node) && (ctx = adapter.property((Object)"@context", node)) != null) {
            node = ctx;
            changed = true;
        }
        if (node == null || adapter.isNull(node) || adapter.isEmpty(node)) {
            node = Map.of();
            adapter = NativeAdapter.instance();
            changed = true;
        }
        return changed ? new TreeIO(node, adapter) : context;
    }

    public static Map<String, ?> inject(Map<String, ?> node, TreeIO context) throws JsonLdException {
        if (!TreeIO.isEmptyOrNull((TreeIO)context)) {
            LinkedHashMap<String, Object> compacted = new LinkedHashMap<String, Object>(node.size() + 1);
            compacted.put("@context", context);
            compacted.putAll(node);
            return compacted;
        }
        return node;
    }

    public static Document load(URI uri, DocumentLoader loader) throws JsonLdException {
        Document document = null;
        if (document == null) {
            DocumentLoader.Options loaderOptions = new DocumentLoader.Options(false, "http://www.w3.org/ns/json-ld#context", List.of("http://www.w3.org/ns/json-ld#context"));
            try {
                document = loader.loadDocument(uri, loaderOptions);
            }
            catch (JsonLdException e) {
                throw new JsonLdException(JsonLdException.ErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "There was a problem encountered loading a remote context [" + String.valueOf(uri) + "]", e);
            }
            if (document == null) {
                throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null.");
            }
        }
        if (!TreeIO.isMap((TreeIO)document.content())) {
            throw new JsonLdException(JsonLdException.ErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is not valid JSON-LD context: " + String.valueOf(document.content()) + ".");
        }
        return document;
    }

    public static class Builder {
        ActiveContext ctx;
        DocumentLoader loader;
        Execution runtime;

        public Builder(JsonLd.Version version) {
            this(null, null, version);
        }

        public Builder(URI base, JsonLd.Version version) {
            this(base, base, version);
        }

        public Builder(URI baseUri, URI baseUrl, JsonLd.Version version) {
            this.ctx = new ActiveContext(baseUri, baseUrl, version);
        }

        public Builder loader(DocumentLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder runtime(Execution runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder baseUri(URI base) {
            this.ctx.setBaseUri(base);
            return this;
        }

        public URI baseUri() {
            return this.ctx.getBaseUri();
        }

        public Context build() throws JsonLdException {
            return this.ctx;
        }

        public Builder update(TreeIO node, URI baseUrl) throws JsonLdException {
            return this.update(node.node(), node.adapter(), baseUrl);
        }

        public Builder update(Object node, TreeAdapter adapter, URI baseUrl) throws JsonLdException {
            this.ctx = this.ctx.newContext(this.loader, this.runtime).build(node, adapter, baseUrl);
            return this;
        }
    }
}

