/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.Document;
import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.lang.Embed;
import com.apicatalog.jsonld.loader.CacheLoader;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.tordf.JsonLdToQuads;
import com.apicatalog.tree.io.TreeAdapter;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.tree.io.java.NativeAdapter;
import com.apicatalog.web.uri.UriValidationPolicy;
import java.net.URI;
import java.time.Duration;
import java.util.Set;

public final class Options {
    public static final boolean DEFAULT_RDF_STAR = false;
    public static final boolean DEFAULT_NUMERIC_ID = false;
    public static final UriValidationPolicy DEFAULT_URI_VALIDATION = UriValidationPolicy.Full;
    private DocumentLoader loader;
    private URI base;
    private boolean compactArrays;
    private boolean compactToRelative;
    private Document expandContext;
    private boolean extractAllScripts;
    private boolean ordered;
    private JsonLd.Version processingMode;
    private boolean generalizedRdf;
    private RdfDirection rdfDirection;
    private boolean useNativeTypes;
    private boolean useRdfType;
    private JsonLdToQuads.RdfJsonLiteralWriter rdfJsonLiteralWriter;
    private Embed embed;
    private boolean explicit;
    private boolean omitDefault;
    private Boolean omitGraph;
    private boolean requiredAll;
    private boolean rdfStar;
    private boolean useNumericId;
    private CacheLoader.Cache<String, Document> documentCache;
    private UriValidationPolicy uriValidation;
    private Duration timeout;
    private ProcessingPolicy undefinedTerms;

    private Options() {
        this.loader = null;
        this.base = null;
        this.compactArrays = true;
        this.compactToRelative = true;
        this.expandContext = null;
        this.extractAllScripts = false;
        this.ordered = false;
        this.processingMode = JsonLd.Version.V1_1;
        this.generalizedRdf = true;
        this.rdfDirection = null;
        this.useNativeTypes = false;
        this.useRdfType = false;
        this.rdfJsonLiteralWriter = JsonLdToQuads.JCS;
        this.embed = Embed.ONCE;
        this.explicit = false;
        this.omitDefault = false;
        this.omitGraph = null;
        this.requiredAll = false;
        this.rdfStar = false;
        this.useNumericId = false;
        this.documentCache = null;
        this.uriValidation = DEFAULT_URI_VALIDATION;
        this.timeout = null;
        this.undefinedTerms = ProcessingPolicy.Ignore;
    }

    private Options(Options options) {
        this.loader = options.loader;
        this.base = options.base;
        this.compactArrays = options.compactArrays;
        this.compactToRelative = options.compactToRelative;
        this.expandContext = options.expandContext;
        this.extractAllScripts = options.extractAllScripts;
        this.ordered = options.ordered;
        this.processingMode = options.processingMode;
        this.generalizedRdf = options.generalizedRdf;
        this.rdfDirection = options.rdfDirection;
        this.useNativeTypes = options.useNativeTypes;
        this.useRdfType = options.useRdfType;
        this.rdfJsonLiteralWriter = options.rdfJsonLiteralWriter;
        this.embed = options.embed;
        this.explicit = options.explicit;
        this.omitDefault = options.omitDefault;
        this.omitGraph = options.omitGraph;
        this.requiredAll = options.requiredAll;
        this.rdfStar = options.rdfStar;
        this.useNumericId = options.useNumericId;
        this.documentCache = options.documentCache;
        this.uriValidation = options.uriValidation;
        this.timeout = options.timeout;
        this.undefinedTerms = options.undefinedTerms;
    }

    public static final Options newOptions() {
        return new Options();
    }

    public static final Options with(DocumentLoader loader) {
        return new Options().loader(loader);
    }

    public static final Options copyOf(Options options) {
        return new Options(options);
    }

    public URI base() {
        return this.base;
    }

    public boolean isCompactArrays() {
        return this.compactArrays;
    }

    public boolean isCompactToRelative() {
        return this.compactToRelative;
    }

    public DocumentLoader loader() {
        return this.loader;
    }

    public boolean isExtractAllScripts() {
        return this.extractAllScripts;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public JsonLd.Version mode() {
        return this.processingMode;
    }

    public boolean isProduceGeneralizedRdf() {
        return this.generalizedRdf;
    }

    public RdfDirection rdfDirection() {
        return this.rdfDirection;
    }

    public boolean useNativeTypes() {
        return this.useNativeTypes;
    }

    public boolean useRdfType() {
        return this.useRdfType;
    }

    public JsonLdToQuads.RdfJsonLiteralWriter rdfJsonLiteralWriter() {
        return this.rdfJsonLiteralWriter;
    }

    public Document expandContext() {
        return this.expandContext;
    }

    public Options base(URI base) {
        this.base = base;
        return this;
    }

    public Options base(String base) {
        this.base = URI.create(base);
        return this;
    }

    public Options compactArrays(boolean compactArrays) {
        this.compactArrays = compactArrays;
        return this;
    }

    public Options compactToRelative(boolean compactToRelative) {
        this.compactToRelative = compactToRelative;
        return this;
    }

    public Options loader(DocumentLoader loader) {
        this.loader = loader;
        return this;
    }

    public Options extractAllScripts(boolean extractAllScripts) {
        this.extractAllScripts = extractAllScripts;
        return this;
    }

    public Options ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public Options mode(JsonLd.Version mode) {
        this.processingMode = mode;
        return this;
    }

    public Options generalizedRdf(boolean produceGeneralizedRdf) {
        this.generalizedRdf = produceGeneralizedRdf;
        return this;
    }

    public Options rdfDirection(RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public Options useNativeTypes(boolean useNativeTypes) {
        this.useNativeTypes = useNativeTypes;
        return this;
    }

    public Options useRdfType(boolean useRdfType) {
        this.useRdfType = useRdfType;
        return this;
    }

    public Options rdfJsonLiteralWriter(JsonLdToQuads.RdfJsonLiteralWriter jsonWriter) {
        this.rdfJsonLiteralWriter = jsonWriter;
        return this;
    }

    public Options expandContext(String uri) {
        if (uri == null) {
            this.expandContext = null;
            return this;
        }
        this.expandContext = Document.of(new TreeIO(Set.of(uri), (TreeAdapter)NativeAdapter.instance()));
        return this;
    }

    public Options expandContext(URI uri) {
        if (uri == null) {
            this.expandContext = null;
            return this;
        }
        return this.expandContext(uri.toString());
    }

    public Options expandContext(TreeIO node) {
        if (node == null) {
            this.expandContext = null;
            return this;
        }
        this.expandContext = Document.of(node);
        return this;
    }

    public Options expandContext(Document context) {
        this.expandContext = context;
        return this;
    }

    public Embed embed() {
        return this.embed;
    }

    public Options embed(Embed embed) {
        this.embed = embed;
        return this;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public Options explicit(boolean explicit) {
        this.explicit = explicit;
        return this;
    }

    public boolean isOmitDefault() {
        return this.omitDefault;
    }

    public Options omitDefault(boolean omitDefault) {
        this.omitDefault = omitDefault;
        return this;
    }

    public Boolean isOmitGraph() {
        return this.omitGraph;
    }

    public Options omitGraph(Boolean omitGraph) {
        this.omitGraph = omitGraph;
        return this;
    }

    public boolean isRequiredAll() {
        return this.requiredAll;
    }

    public Options requiredAll(boolean requiredAll) {
        this.requiredAll = requiredAll;
        return this;
    }

    public Options useNumericId(boolean enable) {
        this.useNumericId = enable;
        return this;
    }

    public boolean useNumericId() {
        return this.useNumericId;
    }

    public CacheLoader.Cache<String, Document> getDocumentCache() {
        return this.documentCache;
    }

    public Options setDocumentCache(CacheLoader.Cache<String, Document> documentCache) {
        this.documentCache = documentCache;
        return this;
    }

    public boolean isRdfStar() {
        return this.rdfStar;
    }

    public Options rdfStar(boolean rdfStar) {
        this.rdfStar = rdfStar;
        return this;
    }

    public UriValidationPolicy uriValidation() {
        return this.uriValidation;
    }

    public Options uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Options timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public ProcessingPolicy undefinedTermsPolicy() {
        return this.undefinedTerms;
    }

    public Options undefinedTermsPolicy(ProcessingPolicy undefinedTerms) {
        this.undefinedTerms = undefinedTerms;
        return this;
    }

    public static enum RdfDirection {
        I18N_DATATYPE,
        COMPOUND_LITERAL;

    }

    public static enum ProcessingPolicy {
        Ignore,
        Fail,
        Warn;

    }
}

