/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld;

import com.apicatalog.jsonld.JsonLdException;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.tree.io.TreeIO;
import com.apicatalog.web.media.MediaType;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class Document {
    protected final MediaType contentType;
    protected final String profile;
    protected final TreeIO content;
    protected final URI documentUrl;
    protected final URI contextUrl;

    protected Document(TreeIO content, MediaType contentType, String profile, URI documentUrl, URI contextUrl) {
        this.content = Objects.requireNonNull(content);
        this.contentType = contentType;
        this.profile = profile;
        this.documentUrl = documentUrl;
        this.contextUrl = contextUrl;
    }

    public static Document of(TreeIO content) {
        return Document.of(content, null, null, null, null);
    }

    public static Document of(TreeIO content, URI documentUrl) {
        return Document.of(content, null, null, documentUrl, null);
    }

    public static Document of(TreeIO content, URI documentUrl, URI contextUrl) {
        return Document.of(content, null, null, documentUrl, contextUrl);
    }

    public static Document of(TreeIO content, MediaType contentType) {
        return Document.of(content, contentType, null, null, null);
    }

    public static Document of(TreeIO content, String profile) {
        return Document.of(content, null, profile, null, null);
    }

    public static Document of(TreeIO content, MediaType contentType, String profile) {
        return Document.of(content, contentType, profile, null, null);
    }

    public static Document of(TreeIO content, MediaType contentType, URI documentUrl) {
        return Document.of(content, contentType, null, documentUrl, null);
    }

    public static Document of(TreeIO content, MediaType contentType, URI documentUrl, URI contextUrl) {
        return Document.of(content, contentType, null, documentUrl, contextUrl);
    }

    public static Document of(TreeIO content, MediaType contentType, String profile, URI documentUrl) {
        return Document.of(content, contentType, profile, documentUrl, null);
    }

    public static Document of(TreeIO content, MediaType contentType, String profile, URI documentUrl, URI contextUrl) {
        return new Document(Objects.requireNonNull(content), contentType != null ? new MediaType(contentType.type(), contentType.subtype()) : null, profile == null && contentType != null ? (String)contentType.findFirstParameter("profile").orElse(null) : profile, documentUrl, contextUrl);
    }

    public static final Document load(URI url, DocumentLoader loader) throws JsonLdException {
        return Document.load(url, loader, false);
    }

    public static final Document load(URI url, DocumentLoader loader, boolean extractAllScripts) throws JsonLdException {
        Objects.requireNonNull(url);
        if (loader == null) {
            throw new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(url) + "].");
        }
        return Optional.ofNullable(loader.loadDocument(url, new DocumentLoader.Options(extractAllScripts, null, null))).orElseThrow(() -> new JsonLdException(JsonLdException.ErrorCode.LOADING_DOCUMENT_FAILED, "Returned document is null [" + String.valueOf(url) + "]."));
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public URI context() {
        return this.contextUrl;
    }

    public URI url() {
        return this.documentUrl;
    }

    public String profile() {
        return this.profile;
    }

    public TreeIO content() {
        return this.content;
    }
}

