/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DefaultObject;
import com.apicatalog.jsonld.lang.DirectionType;
import com.apicatalog.jsonld.lang.GraphObject;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.lang.ListObject;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ObjectExpansion1314 {
    private static final Logger LOGGER = Logger.getLogger(ObjectExpansion1314.class.getName());
    private ActiveContext activeContext;
    private final JsonObject element;
    private final String activeProperty;
    private final URI baseUrl;
    private ActiveContext typeContext;
    private JsonMapBuilder result;
    private String inputType;
    private Map<String, JsonValue> nest;
    private boolean frameExpansion;
    private boolean ordered;

    private ObjectExpansion1314(ActiveContext activeContext, JsonObject element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
    }

    public static final ObjectExpansion1314 with(ActiveContext activeContext, JsonObject element, String activeProperty, URI baseUrl) {
        return new ObjectExpansion1314(activeContext, element, activeProperty, baseUrl);
    }

    public ObjectExpansion1314 frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public ObjectExpansion1314 ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public ObjectExpansion1314 nest(Map<String, JsonValue> nest) {
        this.nest = nest;
        return this;
    }

    public ObjectExpansion1314 typeContext(ActiveContext typeContext) {
        this.typeContext = typeContext;
        return this;
    }

    public ObjectExpansion1314 result(JsonMapBuilder result) {
        this.result = result;
        return this;
    }

    public ObjectExpansion1314 inputType(String inputType) {
        this.inputType = inputType;
        return this;
    }

    public void expand() throws JsonLdError {
        for (String key : Utils.index(this.element.keySet(), this.ordered)) {
            JsonValue value;
            String expandedProperty;
            block121: {
                JsonValue expandedValue;
                block123: {
                    block124: {
                        String expandedStringValue;
                        JsonArrayBuilder array;
                        String expandedStringValue2;
                        block126: {
                            block125: {
                                block122: {
                                    if ("@context".equals(key) || (expandedProperty = this.activeContext.uriExpansion().documentRelative(false).vocab(true).expand(key)) == null || !expandedProperty.contains(":") && !Keywords.contains(expandedProperty)) continue;
                                    value = (JsonValue)this.element.get((Object)key);
                                    if (!Keywords.contains(expandedProperty)) break block121;
                                    expandedValue = null;
                                    if ("@reverse".equals(this.activeProperty)) {
                                        throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_MAP);
                                    }
                                    if (this.result.containsKey(expandedProperty) && Keywords.noneMatch(expandedProperty, "@included", "@type")) {
                                        throw new JsonLdError(JsonLdErrorCode.COLLIDING_KEYWORDS, "Two properties which expand to the same keyword have been detected. A property '" + key + "' expands to '" + expandedProperty + "' but the '" + expandedProperty + "' property is already present.");
                                    }
                                    if (!"@id".equals(expandedProperty)) break block122;
                                    if (!this.activeContext.getOptions().isRdfStar() && "@annotation".equals(this.activeProperty)) {
                                        throw new JsonLdError(JsonLdErrorCode.INVALID_ANNOTATION);
                                    }
                                    if (this.activeContext.getOptions().isRdfStar() && JsonUtils.isNonEmptyObject(value)) {
                                        expandedValue = Expansion.with(this.activeContext, value, null, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                                        if (!NodeObject.isEmbeddedNode(expandedValue)) {
                                            throw new JsonLdError(JsonLdErrorCode.INVALID_EMBEDDED_NODE);
                                        }
                                    } else {
                                        if (!this.frameExpansion && JsonUtils.isNotString(value) && (!this.activeContext.getOptions().isNumericId() || JsonUtils.isNotNumber(value)) || this.frameExpansion && JsonUtils.isNotString(value) && JsonUtils.isNonEmptyObject(value) && (JsonUtils.isNotArray(value) || value.asJsonArray().stream().anyMatch(JsonUtils::isNotString))) {
                                            throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_ID_VALUE, "An @id entry was encountered whose value [" + value + "] was not a string.");
                                        }
                                        if (JsonUtils.isString(value)) {
                                            expandedStringValue2 = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonString)value).getString());
                                            if (expandedStringValue2 != null) {
                                                expandedValue = Json.createValue((String)expandedStringValue2);
                                                if (this.frameExpansion) {
                                                    expandedValue = Json.createArrayBuilder().add(expandedValue).build();
                                                }
                                            } else {
                                                expandedValue = JsonValue.NULL;
                                            }
                                        } else if (JsonUtils.isNumber(value)) {
                                            expandedStringValue2 = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonNumber)value).toString());
                                            if (expandedStringValue2 != null) {
                                                expandedValue = Json.createValue((String)expandedStringValue2);
                                                if (this.frameExpansion) {
                                                    expandedValue = Json.createArrayBuilder().add(expandedValue).build();
                                                }
                                            } else {
                                                expandedValue = JsonValue.NULL;
                                            }
                                        } else if (JsonUtils.isObject(value)) {
                                            expandedValue = Json.createArrayBuilder().add((JsonValue)JsonValue.EMPTY_JSON_OBJECT).build();
                                        } else if (JsonUtils.isEmptyArray(value)) {
                                            expandedValue = JsonValue.EMPTY_JSON_ARRAY;
                                        } else if (JsonUtils.isArray(value)) {
                                            array = Json.createArrayBuilder();
                                            for (JsonValue item : JsonUtils.toCollection(value)) {
                                                expandedStringValue = this.activeContext.uriExpansion().documentRelative(true).vocab(false).expand(((JsonString)item).getString());
                                                if (expandedStringValue == null) continue;
                                                array.add(expandedStringValue);
                                            }
                                            expandedValue = array.build();
                                        }
                                    }
                                    break block123;
                                }
                                if (!"@type".equals(expandedProperty)) break block124;
                                if (!this.frameExpansion && JsonUtils.isNotString(value) && (JsonUtils.isNotArray(value) || value.asJsonArray().stream().anyMatch(JsonUtils::isNotString))) break block125;
                                if (!this.frameExpansion || !JsonUtils.isNotString(value) || !JsonUtils.isNonEmptyObject(value) || !JsonUtils.isNotArray(value) && !value.asJsonArray().stream().anyMatch(JsonUtils::isNotString) || DefaultObject.isDefaultObject(value)) break block126;
                                if (!DefaultObject.getValue(value).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).map(UriUtils::isNotURI).orElse(true).booleanValue()) break block126;
                            }
                            throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_VALUE, "@type value is not valid [" + value + "].");
                        }
                        if (JsonUtils.isEmptyObject(value)) {
                            expandedValue = value;
                        } else if (DefaultObject.isDefaultObject(value)) {
                            Optional<JsonValue> defaultValue = DefaultObject.getValue(value);
                            if (defaultValue.filter(JsonUtils::isString).isPresent()) {
                                expandedValue = Json.createObjectBuilder().add("@default", this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(defaultValue.map(JsonString.class::cast).map(JsonString::getString).get())).build();
                            }
                        } else if (JsonUtils.isString(value)) {
                            expandedStringValue2 = this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(((JsonString)value).getString());
                            if (expandedStringValue2 != null) {
                                expandedValue = Json.createValue((String)expandedStringValue2);
                            }
                        } else if (JsonUtils.isArray(value)) {
                            array = Json.createArrayBuilder();
                            for (JsonValue item : value.asJsonArray()) {
                                if (!JsonUtils.isString(item) || (expandedStringValue = this.typeContext.uriExpansion().vocab(true).documentRelative(true).expand(((JsonString)item).getString())) == null) continue;
                                array.add((JsonValue)Json.createValue((String)expandedStringValue));
                            }
                            expandedValue = array.build();
                        }
                        if (this.result.containsKey("@type")) {
                            JsonValue typeValue = this.result.get("@type").orElse(null);
                            expandedValue = JsonUtils.isArray(typeValue) ? Json.createArrayBuilder((JsonArray)typeValue.asJsonArray()).add(expandedValue).build() : Json.createArrayBuilder().add(typeValue).add(expandedValue).build();
                        }
                        break block123;
                    }
                    if ("@graph".equals(expandedProperty)) {
                        expandedValue = JsonUtils.toJsonArray(Expansion.with(this.typeContext, value, "@graph", this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute());
                    } else if ("@included".equals(expandedProperty)) {
                        if (this.activeContext.inMode(JsonLdVersion.V1_0)) continue;
                        expandedValue = Expansion.with(this.activeContext, value, null, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                        if (JsonUtils.isNotNull(expandedValue)) {
                            if (JsonUtils.isNotArray(expandedValue)) {
                                expandedValue = Json.createArrayBuilder().add(expandedValue).build();
                            }
                            if (expandedValue.asJsonArray().stream().anyMatch(NodeObject::isNotNodeObject)) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INCLUDED_VALUE);
                            }
                            if (this.result.containsKey("@included")) {
                                JsonValue includedValue = this.result.get("@included").orElse(null);
                                JsonArrayBuilder included = JsonUtils.isArray(includedValue) ? Json.createArrayBuilder((JsonArray)includedValue.asJsonArray()) : Json.createArrayBuilder().add(includedValue);
                                expandedValue.asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)included).add(arg_0));
                                expandedValue = included.build();
                            }
                        } else {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INCLUDED_VALUE);
                        }
                    }
                }
                if ("@value".equals(expandedProperty)) {
                    if ("@json".equals(this.inputType)) {
                        if (this.activeContext.inMode(JsonLdVersion.V1_0)) {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT_VALUE);
                        }
                        expandedValue = value;
                    } else if (JsonUtils.isNull(value) || JsonUtils.isScalar(value) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isScalar))) {
                        expandedValue = value;
                        if (this.frameExpansion) {
                            expandedValue = JsonUtils.toJsonArray(expandedValue);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT_VALUE);
                    }
                    if (JsonUtils.isNull(expandedValue)) {
                        this.result.put("@value", JsonValue.NULL);
                        continue;
                    }
                }
                if ("@language".equals(expandedProperty)) {
                    if (JsonUtils.isString(value) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isString))) {
                        if (JsonUtils.isString(value) && !LanguageTag.isWellFormed(((JsonString)value).getString())) {
                            LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", ((JsonString)value).getString());
                        }
                        Object object = expandedValue = JsonUtils.isString(value) ? Json.createValue((String)((JsonString)value).getString().toLowerCase()) : value;
                        if (this.frameExpansion) {
                            expandedValue = JsonUtils.toJsonArray(expandedValue);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_STRING);
                    }
                }
                if ("@direction".equals(expandedProperty)) {
                    if (this.activeContext.inMode(JsonLdVersion.V1_0)) continue;
                    if (JsonUtils.isString(value) && "ltr".equals(((JsonString)value).getString()) || "rtl".equals(((JsonString)value).getString()) || this.frameExpansion && (JsonUtils.isEmptyObject(value) || JsonUtils.isEmptyArray(value) || JsonUtils.isArray(value) && value.asJsonArray().stream().allMatch(JsonUtils::isString))) {
                        expandedValue = value;
                        if (this.frameExpansion) {
                            expandedValue = JsonUtils.toJsonArray(expandedValue);
                        }
                    } else {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                    }
                }
                if ("@index".equals(expandedProperty)) {
                    if (JsonUtils.isNotString(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_INDEX_VALUE);
                    }
                    expandedValue = value;
                }
                if ("@list".equals(expandedProperty)) {
                    if (this.activeProperty == null || "@graph".equals(this.activeProperty)) continue;
                    expandedValue = Expansion.with(this.activeContext, value, this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    if (JsonUtils.isNotArray(expandedValue)) {
                        expandedValue = Json.createArrayBuilder().add(expandedValue).build();
                    }
                }
                if ("@set".equals(expandedProperty)) {
                    expandedValue = Expansion.with(this.activeContext, value, this.activeProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                }
                if ("@reverse".equals(expandedProperty)) {
                    Object entry2;
                    if (JsonUtils.isNotObject(value)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_REVERSE_VALUE);
                    }
                    expandedValue = Expansion.with(this.activeContext, value, "@reverse", this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    if (!JsonUtils.isObject(expandedValue)) continue;
                    JsonObject expandedValueObject = expandedValue.asJsonObject();
                    if (expandedValueObject.containsKey((Object)"@reverse")) {
                        for (Object entry2 : ((JsonValue)expandedValueObject.get((Object)"@reverse")).asJsonObject().entrySet()) {
                            this.result.add((String)entry2.getKey(), (JsonValue)entry2.getValue());
                        }
                    }
                    if (expandedValueObject.size() <= 1 && expandedValueObject.containsKey((Object)"@reverse")) continue;
                    JsonMapBuilder reverseMap = this.result.getMapBuilder("@reverse");
                    entry2 = expandedValueObject.entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        if ("@reverse".equals(entry3.getKey()) || !JsonUtils.isArray((JsonValue)entry3.getValue())) continue;
                        for (JsonValue item : ((JsonValue)entry3.getValue()).asJsonArray()) {
                            if (ListObject.isListObject(item) || ValueObject.isValueObject(item)) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_VALUE);
                            }
                            reverseMap.add((String)entry3.getKey(), item);
                        }
                    }
                    if (!reverseMap.isEmpty()) continue;
                    this.result.remove("@reverse");
                    continue;
                }
                if ("@nest".equals(expandedProperty)) {
                    if (this.nest == null) {
                        this.nest = new LinkedHashMap<String, JsonValue>();
                        this.nest.put(key, (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
                        continue;
                    }
                    if (this.nest.containsKey(key)) continue;
                    this.nest.put(key, (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
                    continue;
                }
                if ("@annotation".equals(expandedProperty)) {
                    if (!this.activeContext.getOptions().isRdfStar()) continue;
                    expandedValue = JsonUtils.toJsonArray(Expansion.with(this.activeContext, value, "@annotation", this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute());
                }
                if (this.frameExpansion && ("@default".equals(expandedProperty) || "@embed".equals(expandedProperty) || "@explicit".equals(expandedProperty) || "@omitDefault".equals(expandedProperty) || "@requireAll".equals(expandedProperty))) {
                    expandedValue = Expansion.with(this.activeContext, value, expandedProperty, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                }
                if (expandedValue == null && (!"@value".equals(expandedProperty) || !"@json".equals(this.inputType))) continue;
                this.result.put(expandedProperty, expandedValue);
                continue;
            }
            Optional<TermDefinition> keyTermDefinition = this.activeContext.getTerm(key);
            Collection containerMapping = keyTermDefinition.map(TermDefinition::getContainerMapping).orElseGet(() -> Collections.emptyList());
            JsonObject expandedValue = null;
            if (keyTermDefinition.map(TermDefinition::getTypeMapping).filter("@json"::equals).isPresent()) {
                expandedValue = Json.createObjectBuilder().add("@value", value).add("@type", "@json").build();
            } else if (containerMapping.contains("@language") && JsonUtils.isObject(value)) {
                expandedValue = JsonValue.EMPTY_JSON_ARRAY;
                DirectionType direction = keyTermDefinition.map(TermDefinition::getDirectionMapping).orElseGet(() -> this.activeContext.getDefaultBaseDirection());
                JsonObject valueObject = value.asJsonObject();
                for (String langCode : Utils.index(valueObject.keySet(), this.ordered)) {
                    JsonValue langValue = (JsonValue)valueObject.get((Object)langCode);
                    if (JsonUtils.isNotArray(langValue)) {
                        langValue = Json.createArrayBuilder().add(langValue).build();
                    }
                    for (JsonValue item : langValue.asJsonArray()) {
                        String expandedLangCode;
                        if (JsonUtils.isNull(item)) continue;
                        if (JsonUtils.isNotString(item)) {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_MAP_VALUE);
                        }
                        JsonObjectBuilder langMap = Json.createObjectBuilder().add("@value", item);
                        if (!"@none".equals(langCode) && !"@none".equals(expandedLangCode = this.activeContext.uriExpansion().vocab(true).expand(langCode))) {
                            if (!LanguageTag.isWellFormed(langCode)) {
                                LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", langCode);
                            }
                            langMap.add("@language", (JsonValue)Json.createValue((String)langCode.toLowerCase()));
                        }
                        if (direction != null && !DirectionType.NULL.equals((Object)direction)) {
                            langMap.add("@direction", (JsonValue)Json.createValue((String)direction.name().toLowerCase()));
                        }
                        expandedValue = Json.createArrayBuilder((JsonArray)expandedValue.asJsonArray()).add(langMap).build();
                    }
                }
            } else if ((containerMapping.contains("@index") || containerMapping.contains("@type") || containerMapping.contains("@id")) && JsonUtils.isObject(value)) {
                expandedValue = JsonValue.EMPTY_JSON_ARRAY;
                String indexKey = keyTermDefinition.map(TermDefinition::getIndexMapping).orElse("@index");
                for (String index : Utils.index(value.asJsonObject().keySet(), this.ordered)) {
                    JsonValue indexValue = (JsonValue)value.asJsonObject().get((Object)index);
                    ActiveContext mapContext = this.activeContext;
                    if (this.activeContext.getPreviousContext() != null && (containerMapping.contains("@id") || containerMapping.contains("@type"))) {
                        mapContext = this.activeContext.getPreviousContext();
                    }
                    Optional<TermDefinition> indexTermDefinition = mapContext.getTerm(index);
                    if (containerMapping.contains("@type") && indexTermDefinition.map(TermDefinition::getLocalContext).isPresent()) {
                        mapContext = mapContext.newContext().create(indexTermDefinition.get().getLocalContext(), indexTermDefinition.get().getBaseUrl());
                    }
                    if (mapContext == null) {
                        mapContext = this.activeContext;
                    }
                    String expandedIndex = this.activeContext.uriExpansion().vocab(true).expand(index);
                    if (JsonUtils.isNotArray(indexValue)) {
                        indexValue = Json.createArrayBuilder().add(indexValue).build();
                    }
                    indexValue = Expansion.with(mapContext, indexValue, key, this.baseUrl).fromMap(true).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
                    for (JsonValue item : indexValue.asJsonArray()) {
                        if (containerMapping.contains("@graph") && !GraphObject.isGraphObject(item)) {
                            item = GraphObject.toGraphObject(item);
                        }
                        if (containerMapping.contains("@index") && !"@index".equals(indexKey) && !"@none".equals(expandedIndex)) {
                            JsonObject reExpandedIndex = this.activeContext.valueExpansion().expand((JsonValue)Json.createValue((String)index), indexKey);
                            String expandedIndexKey = this.activeContext.uriExpansion().vocab(true).expand(indexKey);
                            JsonArrayBuilder indexPropertyValues = Json.createArrayBuilder().add((JsonValue)reExpandedIndex);
                            JsonValue existingValues = (JsonValue)item.asJsonObject().get((Object)expandedIndexKey);
                            if (JsonUtils.isNotNull(existingValues)) {
                                if (JsonUtils.isArray(existingValues)) {
                                    existingValues.asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)indexPropertyValues).add(arg_0));
                                } else {
                                    indexPropertyValues.add(existingValues);
                                }
                            }
                            if (ValueObject.isValueObject(item = Json.createObjectBuilder((JsonObject)item.asJsonObject()).add(expandedIndexKey, indexPropertyValues).build()) && item.asJsonObject().size() > 1) {
                                throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
                            }
                        } else if (containerMapping.contains("@index") && !item.asJsonObject().containsKey((Object)"@index") && !"@none".equals(expandedIndex)) {
                            item = Json.createObjectBuilder((JsonObject)item.asJsonObject()).add("@index", index).build();
                        } else if (containerMapping.contains("@id") && !item.asJsonObject().containsKey((Object)"@id") && !"@none".equals(expandedIndex)) {
                            expandedIndex = this.activeContext.uriExpansion().vocab(false).documentRelative(true).expand(index);
                            item = Json.createObjectBuilder((JsonObject)item.asJsonObject()).add("@id", expandedIndex).build();
                        } else if (containerMapping.contains("@type") && !"@none".equals(expandedIndex)) {
                            JsonArrayBuilder types = Json.createArrayBuilder().add(expandedIndex);
                            JsonValue existingType = (JsonValue)item.asJsonObject().get((Object)"@type");
                            if (JsonUtils.isNotNull(existingType)) {
                                if (JsonUtils.isArray(existingType)) {
                                    existingType.asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)types).add(arg_0));
                                } else {
                                    types.add(existingType);
                                }
                            }
                            item = Json.createObjectBuilder((JsonObject)item.asJsonObject()).add("@type", types).build();
                        }
                        expandedValue = Json.createArrayBuilder((JsonArray)expandedValue.asJsonArray()).add(item).build();
                    }
                }
            } else {
                expandedValue = Expansion.with(this.activeContext, value, key, this.baseUrl).frameExpansion(this.frameExpansion).ordered(this.ordered).compute();
            }
            if (JsonUtils.isNull((JsonValue)expandedValue)) continue;
            if (containerMapping.contains("@list") && !ListObject.isListObject((JsonValue)expandedValue)) {
                expandedValue = ListObject.toListObject((JsonValue)expandedValue);
            }
            if (containerMapping.contains("@graph") && !containerMapping.contains("@id") && !containerMapping.contains("@index")) {
                JsonArrayBuilder array = Json.createArrayBuilder();
                JsonUtils.toStream((JsonValue)expandedValue).map(GraphObject::toGraphObject).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
                expandedValue = array.build();
            }
            if (keyTermDefinition.filter(TermDefinition::isReverseProperty).isPresent()) {
                expandedValue = JsonUtils.toJsonArray((JsonValue)expandedValue);
                for (JsonValue item : expandedValue.asJsonArray()) {
                    if (ListObject.isListObject(item) || ValueObject.isValueObject(item)) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY_VALUE);
                    }
                    this.result.getMapBuilder("@reverse").add(expandedProperty, item);
                }
                continue;
            }
            this.result.add(expandedProperty, (JsonValue)expandedValue);
        }
        if (this.nest != null) {
            this.processNest();
        }
    }

    private void recurse() throws JsonLdError {
        JsonValue propertyContext = this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getLocalContext).orElse(null);
        if (propertyContext != null) {
            this.activeContext = this.activeContext.newContext().overrideProtected(true).create(propertyContext, this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getBaseUrl).orElse(null));
        }
        this.expand();
    }

    private final void processNest() throws JsonLdError {
        for (String nestedKey : Utils.index(this.nest.keySet(), this.ordered)) {
            for (JsonValue nestValue : JsonUtils.toCollection((JsonValue)this.element.get((Object)nestedKey))) {
                if (JsonUtils.isNotObject(nestValue)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                }
                for (String nestedValueKey : nestValue.asJsonObject().keySet()) {
                    if (!"@value".equals(this.typeContext.uriExpansion().vocab(true).expand(nestedValueKey))) continue;
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
                }
                ObjectExpansion1314.with(this.activeContext, nestValue.asJsonObject(), nestedKey, this.baseUrl).inputType(this.inputType).result(this.result).typeContext(this.typeContext).nest(new LinkedHashMap<String, JsonValue>()).frameExpansion(this.frameExpansion).ordered(this.ordered).recurse();
            }
        }
    }
}

