/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.compaction;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.Optional;

public final class ValueCompaction {
    private final ActiveContext activeContext;

    private ValueCompaction(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static ValueCompaction with(ActiveContext activeContext) {
        return new ValueCompaction(activeContext);
    }

    public JsonValue compact(JsonObject value, String activeProperty) throws JsonLdError {
        JsonObject result = value;
        if (this.activeContext.getInverseContext() == null) {
            this.activeContext.createInverseContext();
        }
        Optional<TermDefinition> activePropertyDefinition = this.activeContext.getTerm(activeProperty);
        JsonValue language = null;
        DirectionType direction = null;
        if (activePropertyDefinition.isPresent()) {
            language = activePropertyDefinition.get().getLanguageMapping();
            direction = activePropertyDefinition.get().getDirectionMapping();
        }
        if (language == null) {
            JsonString jsonString = language = this.activeContext.getDefaultLanguage() != null ? Json.createValue((String)this.activeContext.getDefaultLanguage()) : null;
        }
        if (direction == null) {
            direction = this.activeContext.getDefaultBaseDirection();
        }
        if (value.containsKey((Object)"@id") && (value.size() == 1 || value.size() == 2 && value.containsKey((Object)"@index"))) {
            if (activePropertyDefinition.isPresent() && "@id".equals(activePropertyDefinition.get().getTypeMapping())) {
                result = JsonUtils.toJsonValue(this.activeContext.uriCompaction().compact(value.getString("@id")));
            } else if (activePropertyDefinition.isPresent() && "@vocab".equals(activePropertyDefinition.get().getTypeMapping())) {
                result = JsonUtils.toJsonValue(this.activeContext.uriCompaction().vocab(true).compact(value.getString("@id")));
            }
        } else if (value.containsKey((Object)"@type") && activePropertyDefinition.isPresent() && JsonUtils.contains(activePropertyDefinition.get().getTypeMapping(), (JsonValue)value.get((Object)"@type"))) {
            result = (JsonValue)value.get((Object)"@value");
        } else if (activePropertyDefinition.isPresent() && "@none".equals(activePropertyDefinition.get().getTypeMapping()) || value.containsKey((Object)"@type") && (!activePropertyDefinition.isPresent() || !JsonUtils.contains(activePropertyDefinition.get().getTypeMapping(), (JsonValue)value.get((Object)"@type")))) {
            JsonArrayBuilder types = Json.createArrayBuilder();
            JsonValue resultTypes = (JsonValue)result.asJsonObject().get((Object)"@type");
            if (JsonUtils.isNotNull(resultTypes)) {
                for (JsonValue type : JsonUtils.toCollection(resultTypes)) {
                    types.add(this.activeContext.uriCompaction().vocab(true).compact(((JsonString)type).getString()));
                }
                result = Json.createObjectBuilder((JsonObject)result.asJsonObject()).add("@type", (JsonValue)types.build()).build();
            }
        } else if (JsonUtils.isNotString((JsonValue)value.get((Object)"@value"))) {
            if (!value.containsKey((Object)"@index") || activePropertyDefinition.map(td -> td.hasContainerMapping("@index")).orElse(false).booleanValue()) {
                result = (JsonValue)value.get((Object)"@value");
            }
        } else if ((value.containsKey((Object)"@language") && JsonUtils.isString((JsonValue)value.get((Object)"@language")) && JsonUtils.isString(language) && ((JsonString)language).getString().equalsIgnoreCase(value.getString("@language")) || JsonUtils.isNull(language) && (!value.containsKey((Object)"@language") || JsonUtils.isNull((JsonValue)value.get((Object)"@language")))) && (direction != null && direction != DirectionType.NULL && value.containsKey((Object)"@direction") && JsonUtils.isString((JsonValue)value.get((Object)"@direction")) && direction == DirectionType.valueOf(value.getString("@direction").toUpperCase()) || (direction == null || direction == DirectionType.NULL) && (!value.containsKey((Object)"@direction") || DirectionType.NULL == DirectionType.valueOf(value.getString("@direction").toUpperCase()))) && (!value.containsKey((Object)"@index") || activePropertyDefinition.isPresent() && activePropertyDefinition.get().hasContainerMapping("@index"))) {
            result = (JsonValue)value.get((Object)"@value");
        }
        if (JsonUtils.isObject((JsonValue)result)) {
            JsonObjectBuilder resultBuilder = Json.createObjectBuilder();
            for (Map.Entry entry : result.asJsonObject().entrySet()) {
                resultBuilder.add(this.activeContext.uriCompaction().vocab(true).compact((String)entry.getKey()), (JsonValue)entry.getValue());
            }
            result = resultBuilder.build();
        }
        return result;
    }
}

