/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.JsonLdToRdf;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import java.net.URI;
import javax.json.JsonArray;
import javax.json.JsonStructure;

public final class ToRdfProcessor {
    private ToRdfProcessor() {
    }

    public static final RdfDataset toRdf(URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, new DocumentLoaderOptions().setExtractAllScripts(options.isExtractAllScripts()));
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return ToRdfProcessor.toRdf(remoteDocument, options);
    }

    public static final RdfDataset toRdf(Document input, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setProcessingMode(options.getProcessingMode());
        expansionOptions.setBase(options.getBase());
        expansionOptions.setExpandContext(options.getExpandContext());
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        return JsonLdToRdf.with(NodeMapBuilder.with((JsonStructure)expandedInput, new NodeMap()).build(), Rdf.createDataset()).produceGeneralizedRdf(options.isProduceGeneralizedRdf()).rdfDirection(options.getRdfDirection()).build();
    }
}

