/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.DirectionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class InverseContextBuilder {
    private final ActiveContext activeContext;

    private InverseContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
    }

    public static final InverseContextBuilder with(ActiveContext activeContext) {
        return new InverseContextBuilder(activeContext);
    }

    public InverseContext build() {
        InverseContext result = new InverseContext();
        String defaultLanguage = this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage().toLowerCase() : "@none";
        for (String term : this.activeContext.getTerms().stream().sorted().collect(Collectors.toList())) {
            if (this.activeContext.getTerm(term).isEmpty()) continue;
            Optional<String> variable = this.activeContext.getTerm(term).map(TermDefinition::getUriMapping);
            Optional<Collection> containerMapping = this.activeContext.getTerm(term).map(TermDefinition::getContainerMapping);
            String container = ((Collection)containerMapping.filter(Predicate.not(Collection::isEmpty)).orElse(Arrays.asList("@none"))).stream().sorted().collect(Collectors.joining());
            variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@any", "@none", term));
            Optional<JsonValue> languageMapping = this.activeContext.getTerm(term).map(TermDefinition::getLanguageMapping);
            Optional<DirectionType> directionMapping = this.activeContext.getTerm(term).map(TermDefinition::getDirectionMapping);
            if (this.activeContext.getTerm(term).map(TermDefinition::isReverseProperty).orElse(false).booleanValue()) {
                variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@type", "@reverse", term));
                continue;
            }
            if (this.activeContext.getTerm(term).map(TermDefinition::getTypeMapping).map("@none"::equals).orElse(false).booleanValue()) {
                variable.ifPresent(v -> {
                    result.setIfAbsent((String)v, container, "@language", "@any", term);
                    result.setIfAbsent((String)v, container, "@type", "@any", term);
                });
                continue;
            }
            if (this.activeContext.getTerm(term).map(TermDefinition::getTypeMapping).isPresent()) {
                variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@type", this.activeContext.getTerm(term).map(TermDefinition::getTypeMapping).get(), term));
                continue;
            }
            if (languageMapping.isPresent() && directionMapping.isPresent()) {
                String langDir = languageMapping.filter(JsonUtils::isString).isPresent() && directionMapping.get() != DirectionType.NULL ? languageMapping.map(JsonString.class::cast).map(JsonString::getString).orElse("").concat("_").concat(directionMapping.get().name()).toLowerCase() : (languageMapping.filter(JsonUtils::isString).isPresent() ? ((JsonString)languageMapping.get()).getString().toLowerCase() : (directionMapping.get() != DirectionType.NULL ? "_".concat(directionMapping.get().name().toLowerCase()) : "@null"));
                variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@language", langDir, term));
                continue;
            }
            if (languageMapping.isPresent()) {
                String language = JsonUtils.isString(languageMapping.get()) ? ((JsonString)languageMapping.get()).getString().toLowerCase() : "@null";
                variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@language", language, term));
                continue;
            }
            if (directionMapping.isPresent()) {
                String direction = directionMapping.get() != DirectionType.NULL ? "_".concat(directionMapping.get().name().toLowerCase()) : "@none";
                variable.ifPresent(v -> result.setIfAbsent((String)v, container, "@language", direction, term));
                continue;
            }
            if (this.activeContext.getDefaultBaseDirection() != null) {
                variable.ifPresent(v -> {
                    String langDir = (this.activeContext.getDefaultLanguage() != null ? this.activeContext.getDefaultLanguage() : "").concat("_").concat(this.activeContext.getDefaultBaseDirection().name()).toLowerCase();
                    result.setIfAbsent((String)v, container, "@language", langDir, term);
                    result.setIfAbsent((String)v, container, "@language", "@none", term);
                    result.setIfAbsent((String)v, container, "@type", "@none", term);
                });
                continue;
            }
            variable.ifPresent(v -> {
                result.setIfAbsent((String)v, container, "@language", defaultLanguage, term);
                result.setIfAbsent((String)v, container, "@language", "@none", term);
                result.setIfAbsent((String)v, container, "@type", "@none", term);
            });
        }
        return result;
    }
}

