/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.DocumentParser;
import com.apicatalog.jsonld.http.link.Link;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.uri.UriResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class HttpLoader
implements DocumentLoader {
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
    private static final HttpLoader INSTANCE = new HttpLoader(CLIENT);
    public static final int MAX_REDIRECTIONS = 10;
    private static final String PLUS_JSON = "+json";
    private final int maxRedirections;
    private final HttpClient httpClient;

    public HttpLoader(HttpClient httpClient) {
        this(httpClient, 10);
    }

    public HttpLoader(HttpClient httpClient, int maxRedirections) {
        this.httpClient = httpClient;
        this.maxRedirections = maxRedirections;
    }

    public static final DocumentLoader defaultInstance() {
        return INSTANCE;
    }

    @Override
    public Document loadDocument(URI uri, DocumentLoaderOptions options) throws JsonLdError {
        try {
            int redirection = 0;
            boolean done = false;
            URI targetUri = uri;
            MediaType contentType = null;
            URI contextUri = null;
            HttpResponse<InputStream> response = null;
            while (!done) {
                List<String> linkValues;
                HttpRequest request = HttpRequest.newBuilder().GET().uri(targetUri).header("Accept", HttpLoader.getAcceptHeader(options.getRequestProfile())).build();
                response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (response.statusCode() == 301 || response.statusCode() == 302 || response.statusCode() == 303 || response.statusCode() == 307) {
                    Optional<String> location = response.headers().firstValue("Location");
                    if (!location.isPresent()) {
                        throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Header location is required for code [" + response.statusCode() + "].");
                    }
                    targetUri = URI.create(UriResolver.resolve(targetUri, location.get()));
                    if (this.maxRedirections <= 0 || ++redirection < this.maxRedirections) continue;
                    throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Too many redirections");
                }
                if (response.statusCode() != 200) {
                    throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Unexpected response code [" + response.statusCode() + "]");
                }
                Optional<String> contentTypeValue = response.headers().firstValue("Content-Type");
                if (contentTypeValue.isPresent()) {
                    contentType = MediaType.of(contentTypeValue.get());
                }
                if ((linkValues = response.headers().map().get("link")) != null && !linkValues.isEmpty()) {
                    URI baseUri;
                    if (contentType == null || !MediaType.JSON.match(contentType) && !contentType.subtype().toLowerCase().endsWith(PLUS_JSON)) {
                        baseUri = targetUri;
                        Optional<Link> alternate = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("alternate") && l.type().isPresent() && MediaType.JSON_LD.match(l.type().get())).findFirst();
                        if (alternate.isPresent()) {
                            targetUri = alternate.get().target();
                            if (this.maxRedirections <= 0 || ++redirection < this.maxRedirections) continue;
                            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Too many redirections");
                        }
                    }
                    if (contentType != null && !MediaType.JSON_LD.match(contentType) && (MediaType.JSON.match(contentType) || contentType.subtype().toLowerCase().endsWith(PLUS_JSON))) {
                        baseUri = targetUri;
                        List contextUris = linkValues.stream().flatMap(l -> Link.of(l, baseUri).stream()).filter(l -> l.relations().contains("http://www.w3.org/ns/json-ld#context")).collect(Collectors.toList());
                        if (contextUris.size() > 1) {
                            throw new JsonLdError(JsonLdErrorCode.MULTIPLE_CONTEXT_LINK_HEADERS);
                        }
                        if (contextUris.size() == 1) {
                            contextUri = ((Link)contextUris.get(0)).target();
                        }
                    }
                }
                done = true;
            }
            return HttpLoader.createDocument(contentType, targetUri, contextUri, response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, (Throwable)e);
        }
    }

    public static final String getAcceptHeader() {
        return HttpLoader.getAcceptHeader(null);
    }

    public static final String getAcceptHeader(Collection<String> profiles) {
        StringBuilder builder = new StringBuilder();
        builder.append(MediaType.JSON_LD.toString());
        if (profiles != null && !profiles.isEmpty()) {
            builder.append(";profile=\"");
            builder.append(String.join((CharSequence)" ", profiles));
            builder.append("\"");
        }
        builder.append(',');
        builder.append(MediaType.JSON.toString());
        builder.append(";q=0.9,*/*;q=0.8");
        return builder.toString();
    }

    public static final Document createDocument(MediaType type, URI targetUri, URI contextUrl, HttpResponse<InputStream> response) throws JsonLdError, IOException {
        try (InputStream is = response.body();){
            Document remoteDocument = DocumentParser.parse(type, is);
            remoteDocument.setDocumentUrl(targetUri);
            remoteDocument.setContextUrl(contextUrl);
            Document document = remoteDocument;
            return document;
        }
    }
}

