/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.flattening.BlankNodeIdGenerator;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonValue;

public final class NodeMap {
    private final Map<String, Map<String, Map<String, JsonValue>>> index;
    private final BlankNodeIdGenerator generator = new BlankNodeIdGenerator();

    public NodeMap() {
        this.index = new LinkedHashMap<String, Map<String, Map<String, JsonValue>>>();
        this.index.put("@default", new LinkedHashMap());
    }

    public void set(String graphName, String subject, String property, JsonValue value) {
        if (subject == null) {
            return;
        }
        this.index.computeIfAbsent(graphName, x -> new LinkedHashMap()).computeIfAbsent(subject, x -> new LinkedHashMap()).put(property, value);
    }

    public JsonValue get(String graphName, String subject, String property) {
        if (this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject)) {
            return this.index.get(graphName).get(subject).get(property);
        }
        return null;
    }

    public Map<String, JsonValue> get(String graphName, String subject) {
        if (this.index.containsKey(graphName)) {
            return this.index.get(graphName).get(subject);
        }
        return null;
    }

    public boolean contains(String graphName, String subject) {
        return this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject);
    }

    public boolean contains(String graphName, String subject, String property) {
        return this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject) && this.index.get(graphName).get(subject).containsKey(property);
    }

    public Optional<Map<String, Map<String, JsonValue>>> get(String graphName) {
        return Optional.ofNullable(this.index.get(graphName));
    }

    public String createIdentifier(String name) {
        return this.generator.createIdentifier(name);
    }

    public String createIdentifier() {
        return this.generator.createIdentifier();
    }

    public Collection<String> graphs() {
        return this.index.keySet();
    }

    public Collection<String> subjects(String graphName) {
        return this.index.getOrDefault(graphName, Collections.emptyMap()).keySet();
    }

    public Collection<String> properties(String graphName, String subject) {
        return this.index.getOrDefault(graphName, Collections.emptyMap()).getOrDefault(subject, Collections.emptyMap()).keySet();
    }

    public void merge() {
        NodeMap result = new NodeMap();
        for (Map.Entry<String, Map<String, Map<String, JsonValue>>> graphEntry : this.index.entrySet()) {
            for (Map.Entry<String, Map<String, JsonValue>> subject : graphEntry.getValue().entrySet()) {
                if (!result.contains("@merged", subject.getKey())) {
                    result.set("@merged", subject.getKey(), "@id", (JsonValue)Json.createValue((String)subject.getKey()));
                }
                for (Map.Entry<String, JsonValue> property : subject.getValue().entrySet()) {
                    if (!"@type".equals(property.getKey()) && Keywords.matchForm(property.getKey())) {
                        result.set("@merged", subject.getKey(), property.getKey(), property.getValue());
                        continue;
                    }
                    JsonArrayBuilder array = result.contains("@merged", subject.getKey(), property.getKey()) ? Json.createArrayBuilder((JsonArray)JsonUtils.toJsonArray(result.get("@merged", subject.getKey(), property.getKey()))) : Json.createArrayBuilder();
                    JsonUtils.toJsonArray(property.getValue()).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
                    result.set("@merged", subject.getKey(), property.getKey(), (JsonValue)array.build());
                }
            }
        }
        if (result.index.get("@merged") != null) {
            this.index.put("@merged", result.index.get("@merged"));
        }
    }

    public boolean contains(String id) {
        return this.index.containsKey(id);
    }

    public String toString() {
        return Objects.toString(this.index);
    }
}

