/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.expansion.ObjectExpansion1314;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class ObjectExpansion {
    private ActiveContext activeContext;
    private JsonValue propertyContext;
    private JsonObject element;
    private String activeProperty;
    private URI baseUrl;
    private boolean frameExpansion;
    private boolean ordered;
    private boolean fromMap;

    private ObjectExpansion(ActiveContext activeContext, JsonValue propertyContext, JsonObject element, String activeProperty, URI baseUrl) {
        this.activeContext = activeContext;
        this.propertyContext = propertyContext;
        this.element = element;
        this.activeProperty = activeProperty;
        this.baseUrl = baseUrl;
        this.frameExpansion = false;
        this.ordered = false;
        this.fromMap = false;
    }

    public static final ObjectExpansion with(ActiveContext activeContext, JsonValue propertyContext, JsonObject element, String activeProperty, URI baseUrl) {
        return new ObjectExpansion(activeContext, propertyContext, element, activeProperty, baseUrl);
    }

    public ObjectExpansion frameExpansion(boolean value) {
        this.frameExpansion = value;
        return this;
    }

    public ObjectExpansion ordered(boolean value) {
        this.ordered = value;
        return this;
    }

    public ObjectExpansion fromMap(boolean value) {
        this.fromMap = value;
        return this;
    }

    public JsonValue expand() throws JsonLdError {
        this.initPreviousContext();
        this.initPropertyContext();
        this.initLocalContext();
        ActiveContext typeContext = this.activeContext;
        String typeKey = this.processTypeScoped(typeContext);
        String inputType = this.findInputType(typeKey);
        JsonMapBuilder result = JsonMapBuilder.create();
        ObjectExpansion1314.with(this.activeContext, this.element, this.activeProperty, this.baseUrl).inputType(inputType).result(result).typeContext(typeContext).nest(new LinkedHashMap<String, JsonValue>()).frameExpansion(this.frameExpansion).ordered(this.ordered).expand();
        if (result.containsKey("@value")) {
            return this.normalizeValue(result);
        }
        if (result.containsKey("@type")) {
            return this.normalizeType(result);
        }
        if (result.containsKey("@list") || result.containsKey("@set")) {
            return this.normalizeContainer(result);
        }
        return this.normalize(result);
    }

    private void initPropertyContext() throws JsonLdError {
        if (this.propertyContext != null) {
            this.activeContext = this.activeContext.newContext().overrideProtected(true).create(this.propertyContext, this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getBaseUrl).orElse(null));
        }
    }

    private void initPreviousContext() throws JsonLdError {
        if (this.activeContext.getPreviousContext() != null && !this.fromMap) {
            ArrayList keys = new ArrayList(this.element.keySet());
            Collections.sort(keys);
            boolean revert = true;
            for (String key : keys) {
                String expandedKey = this.activeContext.uriExpansion().vocab(true).expand(key);
                if (!"@value".equals(expandedKey) && (!"@id".equals(expandedKey) || this.element.size() != 1)) continue;
                revert = false;
                break;
            }
            if (revert) {
                this.activeContext = this.activeContext.getPreviousContext();
            }
        }
    }

    private void initLocalContext() throws JsonLdError {
        if (this.element.containsKey((Object)"@context")) {
            this.activeContext = this.activeContext.newContext().create((JsonValue)this.element.get((Object)"@context"), this.baseUrl);
        }
    }

    private String processTypeScoped(ActiveContext typeContext) throws JsonLdError {
        String typeKey = null;
        for (String key : this.element.keySet().stream().sorted().collect(Collectors.toSet())) {
            String expandedKey = this.activeContext.uriExpansion().vocab(true).expand(key);
            if (!"@type".equals(expandedKey)) continue;
            if (typeKey == null) {
                typeKey = key;
            }
            List terms = JsonUtils.toCollection((JsonValue)this.element.get((Object)key)).stream().filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).sorted().collect(Collectors.toList());
            for (String term : terms) {
                Optional<JsonValue> localContext = typeContext.getTerm(term).map(TermDefinition::getLocalContext);
                if (!localContext.isPresent()) continue;
                Optional<TermDefinition> valueDefinition = this.activeContext.getTerm(term);
                this.activeContext = this.activeContext.newContext().propagate(false).create(localContext.get(), valueDefinition.map(TermDefinition::getBaseUrl).orElse(null));
            }
        }
        return typeKey;
    }

    private String findInputType(String typeKey) throws JsonLdError {
        String inputType = null;
        if (typeKey != null) {
            JsonValue t = (JsonValue)this.element.get((Object)typeKey);
            String lastValue = null;
            if (JsonUtils.isArray(t)) {
                List sortedValues = t.asJsonArray().stream().filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).sorted().collect(Collectors.toList());
                if (!sortedValues.isEmpty()) {
                    lastValue = (String)sortedValues.get(sortedValues.size() - 1);
                }
            }
            if (JsonUtils.isString(t)) {
                lastValue = ((JsonString)t).getString();
            }
            if (lastValue != null) {
                inputType = this.activeContext.uriExpansion().vocab(true).expand(lastValue);
            }
        }
        return inputType;
    }

    private JsonValue normalizeValue(JsonMapBuilder result) throws JsonLdError {
        if (result.isNotValueObject()) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
        }
        if ((result.containsKey("@direction") || result.containsKey("@language")) && result.containsKey("@type")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_VALUE_OBJECT);
        }
        Optional<JsonValue> type = result.get("@type");
        if (type.isEmpty() || !JsonUtils.contains("@json", type.get())) {
            Optional<JsonValue> value = result.get("@value");
            if (value.isEmpty() || JsonUtils.isNull(value.get()) || JsonUtils.isArray(value.get()) && value.get().asJsonArray().isEmpty()) {
                return JsonValue.NULL;
            }
            if (JsonUtils.isNotString(value.get()) && result.containsKey("@language") && !this.frameExpansion) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_TAGGED_VALUE);
            }
            if (type.isPresent() && (JsonUtils.isNotString(type.get()) || UriUtils.isNotURI(((JsonString)type.get()).getString())) && !this.frameExpansion) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TYPED_VALUE);
            }
        }
        return this.normalize(result);
    }

    private JsonValue normalizeType(JsonMapBuilder result) {
        result.get("@type").filter(JsonUtils::isNotArray).filter(JsonUtils::isNotNull).ifPresent(value -> result.put("@type", (JsonValue)Json.createArrayBuilder().add(value).build()));
        return this.normalize(result);
    }

    private JsonValue normalizeContainer(JsonMapBuilder result) throws JsonLdError {
        Optional<JsonValue> set;
        if (result.size() > 2 || result.size() == 2 && !result.containsKey("@index")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_SET_OR_LIST_OBJECT);
        }
        if (result.containsKey("@set") && (set = result.get("@set")).isPresent()) {
            if (JsonUtils.isNotObject(set.get())) {
                return set.get();
            }
            return this.normalize(JsonMapBuilder.create(set.get().asJsonObject()));
        }
        return this.normalize(result);
    }

    private JsonValue normalize(JsonMapBuilder result) {
        if (result.size() == 1 && result.containsKey("@language")) {
            return JsonValue.NULL;
        }
        if (this.activeProperty == null || "@graph".equals(this.activeProperty)) {
            if (result.isEmpty() && !this.frameExpansion || result.containsKey("@value") || result.containsKey("@list")) {
                return JsonValue.NULL;
            }
            if (result.size() == 1 && result.containsKey("@id") && !this.frameExpansion) {
                return JsonValue.NULL;
            }
        }
        return result.build();
    }
}

