/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.document;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.io.error.RdfReaderException;
import com.apicatalog.rdf.io.error.UnsupportedContentException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonException;

public final class RdfDocument
implements Document {
    private final MediaType contentType;
    private final RdfDataset dataset;
    private final String profile;
    private URI documentUrl;
    private URI contentUrl;

    private RdfDocument(MediaType type, String profile, RdfDataset dataset) {
        this.contentType = type;
        this.profile = profile;
        this.dataset = dataset;
    }

    public static final Document of(RdfDataset dataset) {
        return RdfDocument.of(MediaType.N_QUADS, dataset);
    }

    public static final Document of(MediaType contentType, RdfDataset dataset) {
        RdfDocument.assertContentType(contentType);
        if (dataset == null) {
            throw new IllegalArgumentException("RDF dataset cannot be a null.");
        }
        return new RdfDocument(contentType, null, dataset);
    }

    public static final Document of(InputStream is) throws JsonLdError {
        return RdfDocument.of(MediaType.N_QUADS, is);
    }

    public static final Document of(MediaType type, InputStream is) throws JsonLdError {
        RdfDocument.assertContentType(type);
        try {
            RdfDataset dataset = Rdf.createReader(type, is).readDataset();
            return new RdfDocument(type, null, dataset);
        }
        catch (RdfReaderException | UnsupportedContentException | IOException | JsonException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, e);
        }
    }

    public static final Document of(Reader reader) throws JsonLdError {
        return RdfDocument.of(MediaType.N_QUADS, reader);
    }

    public static final Document of(MediaType type, Reader reader) throws JsonLdError {
        RdfDocument.assertContentType(type);
        try {
            RdfDataset dataset = Rdf.createReader(type, reader).readDataset();
            return new RdfDocument(type, null, dataset);
        }
        catch (RdfReaderException | UnsupportedContentException | IOException | JsonException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, e);
        }
    }

    public static final boolean accepts(MediaType contentType) {
        return Rdf.canRead().contains(contentType);
    }

    private static final void assertContentType(MediaType contentType) {
        if (!RdfDocument.accepts(contentType)) {
            throw new IllegalArgumentException("Unsupported media type '" + contentType + "'. Supported content types are [" + Rdf.canRead().stream().map(MediaType::toString).collect(Collectors.joining(", ")) + "]");
        }
    }

    @Override
    public MediaType getContentType() {
        return this.contentType;
    }

    @Override
    public URI getContextUrl() {
        return this.contentUrl;
    }

    @Override
    public void setContextUrl(URI contextUrl) {
        this.contentUrl = contextUrl;
    }

    @Override
    public URI getDocumentUrl() {
        return this.documentUrl;
    }

    @Override
    public void setDocumentUrl(URI documentUrl) {
        this.documentUrl = documentUrl;
    }

    @Override
    public Optional<String> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    @Override
    public Optional<RdfDataset> getRdfContent() {
        return Optional.of(this.dataset);
    }
}

