/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class Flattening {
    private JsonStructure element;
    private boolean ordered;

    private Flattening(JsonStructure element) {
        this.element = element;
        this.ordered = false;
    }

    public static final Flattening with(JsonStructure element) {
        return new Flattening(element);
    }

    public Flattening ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public JsonArray flatten() throws JsonLdError {
        NodeMap nodeMap = new NodeMap();
        NodeMapBuilder.with(this.element, nodeMap).build();
        Map<String, JsonObject> defaultGraph = nodeMap.get("@default");
        for (String graphName : nodeMap.graphs(this.ordered)) {
            if ("@default".equals(graphName)) continue;
            Map<String, JsonObject> graph = nodeMap.get(graphName);
            if (!defaultGraph.containsKey(graphName)) {
                defaultGraph.put(graphName, Json.createObjectBuilder().add("@id", graphName).build());
            }
            JsonObjectBuilder entry = Json.createObjectBuilder((JsonObject)defaultGraph.get(graphName).asJsonObject());
            JsonArrayBuilder graphArray = Json.createArrayBuilder();
            ArrayList<String> ids = new ArrayList<String>(graph.keySet());
            if (this.ordered) {
                Collections.sort(ids);
            }
            for (String id : ids) {
                JsonValue node = (JsonValue)graph.get(id);
                if (JsonUtils.isObject(node) && node.asJsonObject().size() == 1 && node.asJsonObject().containsKey((Object)"@id")) continue;
                graphArray.add(node);
            }
            entry.add("@graph", (JsonValue)graphArray.build());
            defaultGraph.put(graphName, entry.build());
        }
        LinkedList<JsonValue> flattened = new LinkedList<JsonValue>();
        ArrayList<String> keys = new ArrayList<String>(defaultGraph.keySet());
        if (this.ordered) {
            Collections.sort(keys);
        }
        for (String id : keys) {
            JsonValue node = (JsonValue)defaultGraph.get(id);
            if (JsonUtils.isObject(node) && node.asJsonObject().size() == 1 && node.asJsonObject().containsKey((Object)"@id")) continue;
            flattened.add(node);
        }
        return JsonUtils.toJsonArray(flattened);
    }
}

