/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.expansion.Expansion;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import java.net.URI;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class ExpansionProcessor {
    ExpansionProcessor() {
    }

    public static final JsonArray expand(URI input, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + input + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return ExpansionProcessor.expand(remoteDocument, options, false);
    }

    public static final JsonArray expand(Document input, JsonLdOptions options, boolean frameExpansion) throws JsonLdError {
        JsonObject object;
        JsonValue expanded;
        Optional<JsonStructure> contextValue;
        if (input == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "RemoteDocument is null.");
        }
        JsonStructure jsonStructure = input.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document is not pased JSON."));
        URI baseUri = null;
        URI baseUrl = null;
        if (input.getDocumentUrl() != null) {
            baseUri = baseUrl = input.getDocumentUrl();
        }
        if (baseUrl == null) {
            baseUrl = options.getBase();
        }
        if (options.getBase() != null) {
            baseUri = options.getBase();
        }
        ActiveContext activeContext = new ActiveContext(baseUri, baseUrl, options);
        if (options.getExpandContext() != null && (contextValue = options.getExpandContext().getJsonContent()).isPresent()) {
            JsonArray expandedContext = JsonUtils.toJsonArray((JsonValue)contextValue.get());
            activeContext = expandedContext.size() == 1 && JsonUtils.isObject((JsonValue)expandedContext.get(0)) && expandedContext.getJsonObject(0).containsKey((Object)"@context") ? activeContext.newContext().create((JsonValue)expandedContext.getJsonObject(0).get((Object)"@context"), baseUrl) : activeContext.newContext().create((JsonValue)expandedContext, baseUrl);
        }
        if (input.getContextUrl() != null) {
            activeContext = activeContext.newContext().create((JsonValue)Json.createValue((String)input.getContextUrl().toString()), input.getContextUrl());
        }
        if (JsonUtils.isObject(expanded = Expansion.with(activeContext, (JsonValue)jsonStructure, null, baseUrl).frameExpansion(frameExpansion).ordered(options.isOrdered()).compute()) && (object = expanded.asJsonObject()).size() == 1 && object.containsKey((Object)"@graph")) {
            expanded = (JsonValue)object.get((Object)"@graph");
        }
        if (JsonUtils.isNull(expanded)) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        return JsonUtils.toJsonArray(expanded);
    }
}

