/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.rdf.io.nquad.NQuadsWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class JsonCanonicalizer {
    private JsonCanonicalizer() {
    }

    public static final String canonicalize(JsonValue value) {
        StringWriter writer = new StringWriter();
        try {
            JsonCanonicalizer.canonicalize(value, writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    private static final void canonicalize(JsonValue value, Writer writer) throws IOException {
        if (JsonUtils.isNull(value)) {
            writer.write("null");
        } else if (JsonUtils.isScalar(value)) {
            if (JsonUtils.isNumber(value)) {
                JsonCanonicalizer.canonicalizeNumber((JsonNumber)value, writer);
            } else {
                writer.write(value.toString());
            }
        } else if (JsonUtils.isArray(value)) {
            JsonCanonicalizer.canonicalizeArray(value.asJsonArray(), writer);
        } else if (JsonUtils.isObject(value)) {
            JsonCanonicalizer.canonicalizeObject(value.asJsonObject(), writer);
        }
    }

    private static final void canonicalizeNumber(JsonNumber number, Writer writer) throws IOException {
        String numberString = number.bigDecimalValue().compareTo(BigDecimal.ZERO) == 0 ? "0" : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointRight(21)) >= 0 ? new DecimalFormat("0E00").format(number.bigDecimalValue()).replace("E", "e+") : (number.bigDecimalValue().compareTo(BigDecimal.ONE.movePointLeft(21)) <= 0 ? new DecimalFormat("0E00").format(number.bigDecimalValue()).toLowerCase() : new DecimalFormat("0.#######").format(number.bigDecimalValue())));
        writer.write(numberString);
    }

    private static final void canonicalizeArray(JsonArray value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("[");
        for (JsonValue item : value.asJsonArray()) {
            if (next) {
                writer.write(",");
            }
            JsonCanonicalizer.canonicalize(item, writer);
            next = true;
        }
        writer.write("]");
    }

    private static final void canonicalizeObject(JsonObject value, Writer writer) throws IOException {
        boolean next = false;
        writer.write("{");
        for (String propertyName : value.keySet().stream().sorted().collect(Collectors.toList())) {
            if (next) {
                writer.write(",");
            }
            writer.write("\"");
            writer.write(NQuadsWriter.escape(propertyName));
            writer.write("\":");
            JsonValue propertyValue = (JsonValue)value.get((Object)propertyName);
            JsonCanonicalizer.canonicalize(propertyValue, writer);
            next = true;
        }
        writer.write("}");
    }
}

