/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.ObjectToRdf;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import java.util.LinkedList;
import javax.json.JsonString;
import javax.json.JsonValue;

public final class JsonLdToRdf {
    private final NodeMap nodeMap;
    private final RdfDataset dataset;
    private boolean produceGeneralizedRdf;
    private JsonLdOptions.RdfDirection rdfDirection;

    private JsonLdToRdf(NodeMap nodeMap, RdfDataset dataset) {
        this.nodeMap = nodeMap;
        this.dataset = dataset;
        this.produceGeneralizedRdf = false;
        this.rdfDirection = null;
    }

    public static final JsonLdToRdf with(NodeMap nodeMap, RdfDataset dataset) {
        return new JsonLdToRdf(nodeMap, dataset);
    }

    public JsonLdToRdf produceGeneralizedRdf(boolean enable) {
        this.produceGeneralizedRdf = enable;
        return this;
    }

    public JsonLdToRdf rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfDataset build() throws JsonLdError {
        for (String graphName : this.nodeMap.graphs(true)) {
            RdfResource rdfGraphName;
            if ("@default".equals(graphName)) {
                rdfGraphName = null;
            } else if (BlankNode.isWellFormed(graphName)) {
                rdfGraphName = Rdf.createBlankNode(graphName);
            } else {
                if (!UriUtils.isAbsoluteUri(graphName)) continue;
                rdfGraphName = Rdf.createIRI(graphName);
            }
            for (String subject : this.nodeMap.subjects(graphName, true)) {
                RdfResource rdfSubject = null;
                if (BlankNode.isWellFormed(subject)) {
                    rdfSubject = Rdf.createBlankNode(subject);
                } else if (UriUtils.isAbsoluteUri(subject)) {
                    rdfSubject = Rdf.createIRI(subject);
                }
                if (rdfSubject == null) continue;
                for (String property : this.nodeMap.properties(graphName, subject, true)) {
                    RdfValue rdfObject;
                    if ("@type".equals(property)) {
                        for (JsonValue type : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                            if (JsonUtils.isNotString(type)) continue;
                            String typeString = ((JsonString)type).getString();
                            rdfObject = null;
                            if (BlankNode.isWellFormed(typeString)) {
                                rdfObject = Rdf.createBlankNode(typeString);
                            } else {
                                if (!UriUtils.isAbsoluteUri(typeString)) continue;
                                rdfObject = Rdf.createIRI(typeString);
                            }
                            this.dataset.add(Rdf.createNQuad(rdfSubject, Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rdfObject, rdfGraphName));
                        }
                        continue;
                    }
                    if (Keywords.contains(property) || !UriUtils.isAbsoluteUri(property)) continue;
                    for (JsonValue item : this.nodeMap.get(graphName, subject, property).asJsonArray()) {
                        LinkedList<RdfTriple> listTriples = new LinkedList<RdfTriple>();
                        rdfObject = ObjectToRdf.with(item.asJsonObject(), listTriples, this.nodeMap).rdfDirection(this.rdfDirection).build();
                        if (rdfObject != null) {
                            this.dataset.add(Rdf.createNQuad(rdfSubject, Rdf.createResource(property), rdfObject, rdfGraphName));
                        }
                        listTriples.stream().map(triple -> Rdf.createNQuad(triple, rdfGraphName)).forEach(this.dataset::add);
                    }
                }
            }
        }
        return this.dataset;
    }
}

