/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.impl;

import com.apicatalog.rdf.RdfLiteral;
import java.util.Objects;
import java.util.Optional;

final class RdfLiteralImpl
implements RdfLiteral {
    private final String value;
    private final String langTag;
    private final String dataType;

    protected RdfLiteralImpl(String value) {
        this(value, null, null);
    }

    protected RdfLiteralImpl(String value, String langTag, String datatype) {
        this.value = value;
        this.langTag = langTag;
        this.dataType = RdfLiteralImpl.datatype(langTag, datatype);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDatatype() {
        return this.dataType;
    }

    @Override
    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.langTag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataType, this.langTag, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RdfLiteralImpl other = (RdfLiteralImpl)obj;
        return Objects.equals(this.dataType, other.dataType) && Objects.equals(this.langTag, other.langTag) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        if (this.langTag != null) {
            builder.append('@');
            builder.append(this.langTag);
        } else if (this.dataType != null) {
            builder.append("^^");
            builder.append(this.dataType);
        }
        return builder.toString();
    }

    private static final String datatype(String langTag, String datatype) {
        if (datatype != null) {
            return datatype;
        }
        return langTag == null ? "http://www.w3.org/2001/XMLSchema#string" : "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    }
}

