/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.serialization;

import com.apicatalog.jsonld.serialization.RdfToJsonld;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonValue;

final class GraphMap {
    private Map<String, Map<String, Map<String, JsonValue>>> index = new LinkedHashMap<String, Map<String, Map<String, JsonValue>>>();
    private final Map<String, Map<String, List<RdfToJsonld.Reference>>> usages;

    public GraphMap() {
        this.index.put("@default", new LinkedHashMap());
        this.usages = new LinkedHashMap<String, Map<String, List<RdfToJsonld.Reference>>>();
    }

    public boolean contains(String graphName, String subject) {
        return this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject);
    }

    public boolean contains(String graphName, String subject, String property) {
        return this.index.containsKey(graphName) && this.index.get(graphName).containsKey(subject) && this.index.get(graphName).get(subject).containsKey(property);
    }

    public void set(String graphName, String subject, String property, JsonValue value) {
        this.index.computeIfAbsent(graphName, e -> new LinkedHashMap()).computeIfAbsent(subject, e -> new LinkedHashMap()).put(property, value);
    }

    public JsonValue get(String graphName, String subject, String property) {
        return this.index.get(graphName).get(subject).get(property);
    }

    public Set<String> keys(String graphName) {
        return this.index.get(graphName).keySet();
    }

    public boolean contains(String graphName) {
        return this.index.containsKey(graphName);
    }

    public Map<String, JsonValue> get(String graphName, String subject) {
        return this.index.get(graphName).get(subject);
    }

    public Set<String> keys() {
        return this.index.keySet();
    }

    public List<RdfToJsonld.Reference> getUsages(String graphName, String subject) {
        return this.usages.containsKey(graphName) && this.usages.get(graphName).containsKey(subject) ? this.usages.get(graphName).get(subject) : Collections.emptyList();
    }

    public void addUsage(String graphName, String subject, RdfToJsonld.Reference reference) {
        this.usages.computeIfAbsent(graphName, e -> new LinkedHashMap()).computeIfAbsent(subject, e -> new ArrayList()).add(reference);
    }

    public void remove(String graphName, String subject) {
        this.index.get(graphName).remove(subject);
    }
}

