/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.flattening.Flattening;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.CompactionProcessor;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import java.net.URI;
import javax.json.JsonArray;
import javax.json.JsonStructure;

public final class FlatteningProcessor {
    private FlatteningProcessor() {
    }

    public static final JsonStructure flatten(URI input, URI context, JsonLdOptions options) throws JsonLdError {
        if (context == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, input);
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + context + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static final JsonStructure flatten(Document input, URI context, JsonLdOptions options) throws JsonLdError {
        if (context == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, context);
        Document contextDocument = options.getDocumentLoader().loadDocument(context, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + context + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static final JsonStructure flatten(URI input, Document context, JsonLdOptions options) throws JsonLdError {
        FlatteningProcessor.assertDocumentLoader(options, input);
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return FlatteningProcessor.flatten(remoteDocument, context, options);
    }

    public static final JsonStructure flatten(Document input, Document context, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray flattenedOutput = Flattening.with((JsonStructure)expandedInput).ordered(options.isOrdered()).flatten();
        if (context != null) {
            JsonDocument document = JsonDocument.of(MediaType.JSON_LD, (JsonStructure)flattenedOutput);
            JsonLdOptions compactionOptions = new JsonLdOptions(options);
            if (options.getBase() != null) {
                compactionOptions.setBase(options.getBase());
            } else if (options.isCompactArrays()) {
                compactionOptions.setBase(input.getDocumentUrl());
            }
            flattenedOutput = CompactionProcessor.compact(document, context, compactionOptions);
        }
        return flattenedOutput;
    }

    private static final void assertDocumentLoader(JsonLdOptions options, URI target) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + target + "].");
        }
    }
}

