/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.api.JsonLdErrorCode;
import com.apicatalog.jsonld.api.JsonLdOptions;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.RemoteDocument;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.Framing;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Version;
import com.apicatalog.jsonld.loader.LoadDocumentOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class FramingProcessor {
    private FramingProcessor() {
    }

    public static final JsonObject frame(RemoteDocument input, RemoteDocument frame, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray expandedFrame = ExpansionProcessor.expand(frame, expansionOptions, true);
        JsonObject frameObject = frame.getDocument().getJsonStructure().asJsonObject();
        JsonObject context = JsonValue.EMPTY_JSON_OBJECT;
        if (frameObject.containsKey((Object)"@context")) {
            context = (JsonValue)frameObject.get((Object)"@context");
        }
        URI contextBase = frame.getContextUrl() != null ? frame.getDocumentUrl() : options.getBase();
        ActiveContext activeContext = new ActiveContext(input.getDocumentUrl(), input.getDocumentUrl(), options).newContext().create((JsonValue)context, contextBase);
        ArrayList<String> frameKeysExpanded = new ArrayList<String>();
        for (String key : frameObject.keySet()) {
            frameKeysExpanded.add(activeContext.uriExpansion().vocab(true).expand(key));
        }
        boolean frameDefault = frameKeysExpanded.contains("@graph");
        FramingState state = new FramingState();
        state.setEmbed(options.getEmbed());
        state.setEmbedded(false);
        state.setExplicitInclusion(options.isExplicit());
        state.setRequireAll(options.isRequiredAll());
        state.setOmitDefault(options.isOmitDefault());
        state.setGraphMap(NodeMapBuilder.with((JsonStructure)expandedInput, new NodeMap()).build());
        if (frameDefault) {
            state.setGraphName("@default");
        } else {
            state.setGraphName("@merged");
            state.getGraphMap().merge();
        }
        LinkedHashMap<String, JsonValue> resultMap = new LinkedHashMap<String, JsonValue>();
        Framing.with(state, new ArrayList<String>(state.getGraphMap().subjects(state.getGraphName())), Frame.of((JsonStructure)expandedFrame), resultMap, null).ordered(options.isOrdered()).frame();
        Collection result = resultMap.values();
        if (!activeContext.inMode(Version.V1_0)) {
            result = FramingProcessor.removeBlankId(result);
        }
        result = result.stream().map(FramingProcessor::removePreserve).collect(Collectors.toList());
        JsonValue compactedResults = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact((JsonValue)JsonUtils.toJsonArray(result));
        if (JsonUtils.isEmptyArray(compactedResults)) {
            compactedResults = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedResults)) {
            String key = activeContext.uriCompaction().vocab(true).compact("@graph");
            compactedResults = Json.createObjectBuilder().add(key, compactedResults).build();
        }
        compactedResults = FramingProcessor.replaceNull(compactedResults);
        boolean omitGraph = options.isOmitGraph() == null ? activeContext.inMode(Version.V1_1) : options.isOmitGraph().booleanValue();
        if (!omitGraph && !compactedResults.asJsonObject().containsKey((Object)"@graph")) {
            compactedResults = compactedResults.asJsonObject().isEmpty() ? Json.createObjectBuilder().add("@graph", (JsonValue)JsonValue.EMPTY_JSON_ARRAY).build() : Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add(compactedResults)).build();
        }
        if (JsonUtils.isNotEmptyArray((JsonValue)context) && JsonUtils.isNotEmptyObject((JsonValue)context)) {
            compactedResults = Json.createObjectBuilder((JsonObject)compactedResults.asJsonObject()).add("@context", (JsonValue)context).build();
        }
        return compactedResults.asJsonObject();
    }

    public static final JsonObject frame(URI input, URI frame, JsonLdOptions options) throws JsonLdError {
        return FramingProcessor.frame(FramingProcessor.getDocument(input, options), FramingProcessor.getDocument(frame, options), options);
    }

    private static RemoteDocument getDocument(URI document, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        RemoteDocument remoteDocument = options.getDocumentLoader().loadDocument(document, new LoadDocumentOptions().setExtractAllScripts(options.isExtractAllScripts()));
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Cannot load document [" + document + "].");
        }
        return remoteDocument;
    }

    private static final JsonValue removePreserve(JsonValue value) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (JsonValue item : value.asJsonArray()) {
                array.add(FramingProcessor.removePreserve(item));
            }
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@preserve".equals(entry.getKey())) {
                return (JsonValue)((JsonValue)entry.getValue()).asJsonArray().get(0);
            }
            object.add((String)entry.getKey(), FramingProcessor.removePreserve((JsonValue)entry.getValue()));
        }
        return object.build();
    }

    private static final JsonValue replaceNull(JsonValue value) {
        if (JsonUtils.isString(value) && "@null".equals(((JsonString)value).getString())) {
            return JsonValue.NULL;
        }
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().stream().map(FramingProcessor::replaceNull).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
            JsonArray result = array.build();
            return result.size() != 1 || JsonUtils.isNotNull((JsonValue)result.get(0)) ? result : JsonValue.EMPTY_JSON_ARRAY;
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            object.add((String)entry.getKey(), FramingProcessor.replaceNull((JsonValue)entry.getValue()));
        }
        return object.build();
    }

    private static final Collection<JsonValue> removeBlankId(Collection<JsonValue> array) {
        HashMap candiates = new HashMap();
        array.stream().forEach(v -> FramingProcessor.findBlankNodes(v, candiates));
        List remove = candiates.entrySet().stream().filter(e -> (Integer)e.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (remove.isEmpty()) {
            return array;
        }
        return array.stream().map(v -> FramingProcessor.removeBlankIdKey(v, remove)).collect(Collectors.toList());
    }

    private static final JsonValue removeBlankIdKey(JsonValue value, List<String> blankNodes) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (JsonValue item : value.asJsonArray()) {
                array.add(FramingProcessor.removeBlankIdKey(item, blankNodes));
            }
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@id".equals(entry.getKey()) && JsonUtils.isString((JsonValue)entry.getValue()) && blankNodes.contains(((JsonString)entry.getValue()).getString())) continue;
            object.add((String)entry.getKey(), FramingProcessor.removeBlankIdKey((JsonValue)entry.getValue(), blankNodes));
        }
        return object.build();
    }

    private static final void findBlankNodes(JsonValue value, Map<String, Integer> blankNodes) {
        if (JsonUtils.isString(value)) {
            if (BlankNode.isWellFormed(((JsonString)value).getString())) {
                Integer count = blankNodes.computeIfAbsent(((JsonString)value).getString(), x -> 0);
                count = count + 1;
                blankNodes.put(((JsonString)value).getString(), count);
            }
            return;
        }
        if (JsonUtils.isScalar(value)) {
            return;
        }
        if (JsonUtils.isArray(value)) {
            for (JsonValue item : value.asJsonArray()) {
                FramingProcessor.findBlankNodes(item, blankNodes);
            }
            return;
        }
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            FramingProcessor.findBlankNodes((JsonValue)entry.getValue(), blankNodes);
        }
    }
}

