/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.api.JsonLdError;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import javax.json.JsonValue;

public final class ScalarExpansion {
    private ActiveContext activeContext;
    private JsonValue propertyContext;
    private JsonValue element;
    private String activeProperty;

    private ScalarExpansion(ActiveContext activeContext, JsonValue propertyContext, JsonValue element, String activeProperty) {
        this.activeContext = activeContext;
        this.propertyContext = propertyContext;
        this.element = element;
        this.activeProperty = activeProperty;
    }

    public static final ScalarExpansion with(ActiveContext activeContext, JsonValue propertyContext, JsonValue element, String activeProperty) {
        return new ScalarExpansion(activeContext, propertyContext, element, activeProperty);
    }

    public JsonValue expand() throws JsonLdError {
        if (this.activeProperty == null || "@graph".equals(this.activeProperty)) {
            return JsonValue.NULL;
        }
        if (this.propertyContext != null) {
            this.activeContext = this.activeContext.newContext().create(this.propertyContext, this.activeContext.getTerm(this.activeProperty).map(TermDefinition::getBaseUrl).orElse(null));
        }
        return this.activeContext.valueExpansion().expand(this.element, this.activeProperty);
    }
}

