/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.RemoteDocument;
import java.net.URI;
import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

public final class JsonLdInput {
    private final RemoteDocument document;

    public JsonLdInput(RemoteDocument document) {
        this.document = document;
    }

    public static JsonLdInput of(JsonObject ... objects) {
        RemoteDocument document = new RemoteDocument();
        document.setDocument(Document.of((JsonStructure)Json.createArrayBuilder(Arrays.asList(objects)).build()));
        return new JsonLdInput(document);
    }

    public static JsonLdInput of(URI documentUrl) {
        RemoteDocument document = new RemoteDocument();
        document.setDocumentUrl(documentUrl);
        return new JsonLdInput(document);
    }

    public static JsonLdInput of(RemoteDocument remoteDocument) {
        return new JsonLdInput(remoteDocument);
    }

    public RemoteDocument asDocument() {
        return this.document;
    }
}

