/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.api;

import com.apicatalog.jsonld.json.JsonUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public final class JsonLdContext {
    private final Collection<JsonValue> contexts;

    protected JsonLdContext() {
        this(new LinkedList<JsonValue>());
    }

    protected JsonLdContext(Collection<JsonValue> contexts) {
        this.contexts = contexts;
    }

    public static JsonLdContext of(URI contextLocation) {
        return new JsonLdContext().add(contextLocation);
    }

    public static JsonLdContext of(JsonObject contextObject) {
        return new JsonLdContext().add(contextObject);
    }

    public static JsonLdContext of(Collection<JsonValue> contexts) {
        return new JsonLdContext(contexts);
    }

    public static JsonLdContext of(JsonStructure jsonStructure) {
        if (JsonUtils.isObject((JsonValue)jsonStructure)) {
            return new JsonLdContext().add(jsonStructure.asJsonObject());
        }
        return new JsonLdContext(new ArrayList<JsonValue>((Collection<JsonValue>)jsonStructure.asJsonArray()));
    }

    public JsonLdContext add(URI contextLocation) {
        this.contexts.add((JsonValue)Json.createValue((String)contextLocation.toString()));
        return this;
    }

    public JsonLdContext add(JsonObject contextObject) {
        this.contexts.add((JsonValue)contextObject);
        return this;
    }

    public JsonArray asJsonArray() {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        this.contexts.forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }
}

