/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.client.Fn2;
import com.aphyr.riemann.client.IPromise;
import com.aphyr.riemann.client.Promise;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MapPromise<T1, T2>
implements IPromise<T2> {
    public static final Object sentinel = new Object();
    public volatile Object value = sentinel;
    public final IPromise<T1> p;
    public final Fn2<T1, T2> f;

    public MapPromise(IPromise<T1> p, Fn2<T1, T2> f) {
        this.p = p;
        this.f = f;
    }

    public Object mapCapturingExceptions(T1 x) {
        try {
            return this.f.call(x);
        }
        catch (RuntimeException e) {
            return e;
        }
    }

    @Override
    public void deliver(Object value) {
        this.p.deliver(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T2 deref() throws IOException {
        if (sentinel == this.value) {
            MapPromise mapPromise = this;
            synchronized (mapPromise) {
                if (sentinel == this.value) {
                    this.value = this.mapCapturingExceptions(this.p.deref());
                }
            }
        }
        return (T2)Promise.rehydrate(this.value);
    }

    @Override
    public T2 deref(long time, TimeUnit unit) throws IOException {
        return this.deref(time, unit, (T2)null);
    }

    @Override
    public T2 deref(long time, TimeUnit unit, T2 timeoutValue) throws IOException {
        return (T2)this.unsafeDeref(time, unit, timeoutValue);
    }

    @Override
    public Object deref(long millis, Object timeoutValue) throws IOException {
        return this.unsafeDeref(millis, TimeUnit.MILLISECONDS, timeoutValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unsafeDeref(long time, TimeUnit unit, Object timeoutValue) throws IOException {
        if (sentinel == this.value) {
            MapPromise mapPromise = this;
            synchronized (mapPromise) {
                if (sentinel == this.value) {
                    Object response = this.p.unsafeDeref(time, unit, sentinel);
                    if (sentinel == response) {
                        return timeoutValue;
                    }
                    this.value = this.mapCapturingExceptions(response);
                }
            }
        }
        return Promise.rehydrate(this.value);
    }

    @Override
    public <T3> IPromise<T3> map(Fn2<T2, T3> f) {
        return new MapPromise<T2, T3>(this, f);
    }
}

