/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.AsynchronizeTransport;
import com.aphyr.riemann.client.AsynchronousTransport;
import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.Fn2;
import com.aphyr.riemann.client.IPromise;
import com.aphyr.riemann.client.IRiemannClient;
import com.aphyr.riemann.client.MsgValidator;
import com.aphyr.riemann.client.RiemannScheduler;
import com.aphyr.riemann.client.SynchronousTransport;
import com.aphyr.riemann.client.TcpTransport;
import com.aphyr.riemann.client.Transport;
import com.aphyr.riemann.client.UdpTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class RiemannClient
implements IRiemannClient {
    public static final MsgValidator validate = new MsgValidator();
    public volatile RiemannScheduler scheduler = null;
    public final AsynchronousTransport transport;

    public static IPromise<Proto.Msg> sendException(IRiemannClient client, String service, Throwable t) {
        StringBuilder desc = new StringBuilder();
        desc.append(t.toString());
        desc.append("\n\n");
        for (StackTraceElement e : t.getStackTrace()) {
            desc.append(e);
            desc.append("\n");
        }
        return client.event().service(service).state("error").tag("exception").tag(t.getClass().getSimpleName()).description(desc.toString()).send();
    }

    public static RiemannClient wrap(SynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient wrap(AsynchronousTransport t) {
        return new RiemannClient(t);
    }

    public static RiemannClient tcp(InetSocketAddress address) throws IOException {
        return RiemannClient.wrap(new TcpTransport(address));
    }

    public static RiemannClient tcp(String host, int port) throws IOException {
        return RiemannClient.wrap(new TcpTransport(host, port));
    }

    public static RiemannClient tcp(String host) throws IOException {
        return RiemannClient.wrap(new TcpTransport(host));
    }

    public static RiemannClient tcp(int port) throws IOException {
        return RiemannClient.wrap(new TcpTransport(port));
    }

    public static RiemannClient udp(InetSocketAddress address) throws IOException {
        return RiemannClient.wrap(new UdpTransport(address));
    }

    public static RiemannClient udp(String host, int port) throws IOException {
        return RiemannClient.wrap(new UdpTransport(host, port));
    }

    public static RiemannClient udp(String host) throws IOException {
        return RiemannClient.wrap(new UdpTransport(host));
    }

    public static RiemannClient udp(int port) throws IOException {
        return RiemannClient.wrap(new UdpTransport(port));
    }

    public RiemannClient(SynchronousTransport t) {
        this(new AsynchronizeTransport(t));
    }

    public RiemannClient(AsynchronousTransport t) {
        this.transport = t;
    }

    @Override
    public EventDSL event() {
        return new EventDSL(this);
    }

    @Override
    public IPromise<Proto.Msg> sendMessage(Proto.Msg m) {
        return this.transport.sendMessage(m).map(validate);
    }

    @Override
    public IPromise<Proto.Msg> sendEvent(Proto.Event event) {
        return this.sendMessage(Proto.Msg.newBuilder().addEvents(event).build());
    }

    @Override
    public IPromise<Proto.Msg> sendEvents(Proto.Event ... events) {
        return this.sendEvents(Arrays.asList(events));
    }

    @Override
    public IPromise<Proto.Msg> sendEvents(List<Proto.Event> events) {
        return this.sendMessage(Proto.Msg.newBuilder().addAllEvents(events).build());
    }

    @Override
    public IPromise<Proto.Msg> sendException(String service, Throwable t) {
        return RiemannClient.sendException(this, service, t);
    }

    @Override
    public IPromise<List<Proto.Event>> query(String q) {
        return this.sendMessage(Proto.Msg.newBuilder().setQuery(Proto.Query.newBuilder().setString(q).build()).build()).map(new Fn2<Proto.Msg, List<Proto.Event>>(){

            @Override
            public List<Proto.Event> call(Proto.Msg m) {
                return Collections.unmodifiableList(m.getEventsList());
            }
        });
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public void connect() throws IOException {
        this.transport.connect();
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void close() {
        this.transport.close();
    }

    @Override
    public void reconnect() throws IOException {
        this.transport.reconnect();
    }

    @Override
    public void flush() throws IOException {
        this.transport.flush();
    }

    public synchronized RiemannScheduler scheduler() {
        if (this.scheduler == null) {
            this.scheduler = new RiemannScheduler(this);
        }
        return this.scheduler;
    }
}

