/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class ReconnectHandler
extends SimpleChannelUpstreamHandler {
    final Bootstrap bootstrap;
    public final Timer timer;
    public long startTime = -1L;
    public final AtomicLong delay;
    public final TimeUnit unit;

    public ReconnectHandler(ClientBootstrap bootstrap, Timer timer, AtomicLong delay, TimeUnit unit) {
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.delay = delay;
        this.unit = unit;
    }

    public ReconnectHandler(ConnectionlessBootstrap bootstrap, Timer timer, AtomicLong delay, TimeUnit unit) {
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.delay = delay;
        this.unit = unit;
    }

    InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.bootstrap.getOption("remoteAddress");
    }

    public void channelDisconnected(ChannelHandlerContext c, ChannelStateEvent e) throws Exception {
        e.getChannel().close();
        super.channelDisconnected(c, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            this.timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    if (ReconnectHandler.this.bootstrap instanceof ClientBootstrap) {
                        ((ClientBootstrap)ReconnectHandler.this.bootstrap).connect();
                    } else if (ReconnectHandler.this.bootstrap instanceof ConnectionlessBootstrap) {
                        ((ConnectionlessBootstrap)ReconnectHandler.this.bootstrap).connect();
                    }
                }
            }, this.delay.get(), this.unit);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        super.channelClosed(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext c, ChannelStateEvent e) throws Exception {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
        super.channelConnected(c, e);
    }

    public void exceptionCaught(ChannelHandlerContext c, ExceptionEvent e) {
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            this.startTime = -1L;
        } else if (!(cause instanceof ReadTimeoutException)) {
            c.sendUpstream((ChannelEvent)e);
        }
        c.getChannel().close();
    }
}

