package com.apandroid.chiptextview

import android.annotation.TargetApi
import android.graphics.Outline
import android.graphics.Rect
import android.os.Build
import android.view.View
import android.view.ViewOutlineProvider

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
class ChipOutlineProvider : ViewOutlineProvider() {

    private val rect by lazy { Rect() }

    override fun getOutline(view: View, outline: Outline) {
        view.run {
            rect.left = paddingLeft
            rect.top = paddingTop
            rect.right = width - paddingRight
            rect.bottom = height - paddingBottom
        }

        outline.setRoundRect(rect, rect.height() / 2f)
    }
}