/*
 * Decompiled with CFR 0.152.
 */
package com.apandroid.chiptextview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.apandroid.chiptextview.R;
import com.apandroid.chiptextview.RoundedCornersDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010L\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0002J\u0018\u0010M\u001a\u00020G2\u0006\u0010N\u001a\u00020@2\u0006\u0010O\u001a\u00020@H\u0017J\b\u0010P\u001a\u00020GH\u0014J\u0006\u0010Q\u001a\u00020GJ\u0006\u0010R\u001a\u00020GJ\u0010\u0010S\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0014J\u0018\u0010T\u001a\u00020G2\u0006\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\tH\u0014J \u0010W\u001a\u00020G2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010X\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0010\u0010[\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0010\u0010\\\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0010\u0010\u0018\u001a\u00020G2\b\u0010]\u001a\u0004\u0018\u00010^J\u000e\u0010_\u001a\u00020G2\u0006\u0010`\u001a\u00020\tJ\u000e\u0010a\u001a\u00020G2\u0006\u0010`\u001a\u00020\tJ&\u0010a\u001a\u00020G2\u0006\u0010b\u001a\u00020\t2\u0006\u0010c\u001a\u00020\t2\u0006\u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020\tJ\u000e\u0010f\u001a\u00020G2\u0006\u0010`\u001a\u00020\tJ\u0006\u0010g\u001a\u00020GJ\u0006\u0010h\u001a\u00020GJ\u0012\u0010i\u001a\u00020j2\b\u0010k\u001a\u0004\u0018\u00010^H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R$\u0010!\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0010\"\u0004\b#\u0010\u0012R$\u0010$\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010\u0012R$\u0010'\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010\u0012R4\u0010,\u001a\n +*\u0004\u0018\u00010*0*2\u000e\u0010\r\u001a\n +*\u0004\u0018\u00010*0*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0012R(\u00105\u001a\u0004\u0018\u0001042\b\u0010\r\u001a\u0004\u0018\u000104@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R$\u0010:\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0010\"\u0004\b<\u0010\u0012R\u000e\u0010=\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010A\u001a\u00020@2\u0006\u0010\r\u001a\u00020@8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006l"}, d2={"Lcom/apandroid/chiptextview/ChipTextView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backgroundPaint", "Landroid/graphics/Paint;", "value", "chipBackgroundColor", "getChipBackgroundColor", "()I", "setChipBackgroundColor", "(I)V", "<set-?>", "Lcom/apandroid/chiptextview/RoundedCornersDrawable;", "chipBackgroundDrawable", "getChipBackgroundDrawable", "()Lcom/apandroid/chiptextview/RoundedCornersDrawable;", "setChipBackgroundDrawable", "(Lcom/apandroid/chiptextview/RoundedCornersDrawable;)V", "chipBackgroundDrawableRect", "Landroid/graphics/Rect;", "chipBackgroundRect", "Landroid/graphics/RectF;", "chipPaddingBottom", "getChipPaddingBottom", "setChipPaddingBottom", "chipPaddingEnd", "getChipPaddingEnd", "setChipPaddingEnd", "chipPaddingStart", "getChipPaddingStart", "setChipPaddingStart", "chipPaddingTop", "getChipPaddingTop", "setChipPaddingTop", "Landroid/graphics/Typeface;", "kotlin.jvm.PlatformType", "font", "getFont", "()Landroid/graphics/Typeface;", "setFont", "(Landroid/graphics/Typeface;)V", "paintFlags", "getPaintFlags", "setPaintFlags", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textColor", "getTextColor", "setTextColor", "textMeasuringRect", "textPaint", "Landroid/text/TextPaint;", "", "textSize", "getTextSize", "()F", "setTextSize", "(F)V", "calcChipBackgroundRect", "", "drawChipBackgroundColor", "canvas", "Landroid/graphics/Canvas;", "drawChipBackgroundDrawable", "drawText", "drawableHotspotChanged", "x", "y", "drawableStateChanged", "hideStrikeThroughText", "hideTextUnderline", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "readAttributes", "readChipPadding", "array", "Landroid/content/res/TypedArray;", "readFont", "readTextAttributes", "drawable", "Landroid/graphics/drawable/Drawable;", "setChipHorizontalPadding", "padding", "setChipPadding", "left", "top", "right", "bottom", "setChipVerticalPadding", "strikeThroughText", "underlineText", "verifyDrawable", "", "who", "chiptextview_release"})
public class ChipTextView
extends View {
    private final TextPaint textPaint;
    private final Paint backgroundPaint;
    private final Rect textMeasuringRect;
    private final RectF chipBackgroundRect;
    private final Rect chipBackgroundDrawableRect;
    @Nullable
    private RoundedCornersDrawable chipBackgroundDrawable;
    @Nullable
    private String text;
    private int chipPaddingStart;
    private int chipPaddingEnd;
    private int chipPaddingTop;
    private int chipPaddingBottom;

    @Nullable
    public final RoundedCornersDrawable getChipBackgroundDrawable() {
        return this.chipBackgroundDrawable;
    }

    private final void setChipBackgroundDrawable(RoundedCornersDrawable roundedCornersDrawable) {
        this.chipBackgroundDrawable = roundedCornersDrawable;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        this.text = value;
        this.requestLayout();
    }

    public final float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public final void setTextSize(float value) {
        this.textPaint.setTextSize(value);
        this.requestLayout();
    }

    public final int getTextColor() {
        return this.textPaint.getColor();
    }

    public final void setTextColor(int value) {
        this.textPaint.setColor(value);
        this.invalidate();
    }

    public final Typeface getFont() {
        return this.textPaint.getTypeface();
    }

    public final void setFont(Typeface value) {
        this.textPaint.setTypeface(value);
        this.requestLayout();
    }

    public final int getPaintFlags() {
        return this.textPaint.getFlags();
    }

    public final void setPaintFlags(int value) {
        this.textPaint.setFlags(value);
        this.requestLayout();
    }

    public final int getChipPaddingStart() {
        return this.chipPaddingStart;
    }

    public final void setChipPaddingStart(int value) {
        this.chipPaddingStart = value;
        this.requestLayout();
    }

    public final int getChipPaddingEnd() {
        return this.chipPaddingEnd;
    }

    public final void setChipPaddingEnd(int value) {
        this.chipPaddingEnd = value;
        this.requestLayout();
    }

    public final int getChipPaddingTop() {
        return this.chipPaddingTop;
    }

    public final void setChipPaddingTop(int value) {
        this.chipPaddingTop = value;
        this.requestLayout();
    }

    public final int getChipPaddingBottom() {
        return this.chipPaddingBottom;
    }

    public final void setChipPaddingBottom(int value) {
        this.chipPaddingBottom = value;
        this.requestLayout();
    }

    public final int getChipBackgroundColor() {
        return this.backgroundPaint.getColor();
    }

    public final void setChipBackgroundColor(int value) {
        this.backgroundPaint.setColor(value);
        this.invalidate();
    }

    private final void readAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray array;
        TypedArray typedArray;
        TypedArray $receiver = typedArray = (array = context.obtainStyledAttributes(attrs, R.styleable.ChipTextView, defStyleAttr, R.style.ChipTextViewDefaultStyle));
        this.setChipBackgroundColor($receiver.getColor(R.styleable.ChipTextView_ctv_chipColor, -16777216));
        this.setChipBackgroundDrawable($receiver.getDrawable(R.styleable.ChipTextView_ctv_chipBackgroundDrawable));
        TypedArray typedArray2 = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray2, (String)"this");
        this.readTextAttributes(typedArray2);
        this.readFont($receiver);
        this.readChipPadding($receiver);
        $receiver.recycle();
    }

    private final void readTextAttributes(TypedArray array) {
        TextPaint textPaint;
        TypedArray typedArray;
        TypedArray $receiver = typedArray = array;
        this.setText($receiver.getString(R.styleable.ChipTextView_ctv_text));
        TextPaint $receiver2 = textPaint = this.textPaint;
        $receiver2.setTextSize($receiver.getDimension(R.styleable.ChipTextView_ctv_textSize, 0.0f));
        $receiver2.setColor($receiver.getColor(R.styleable.ChipTextView_ctv_textColor, -1));
    }

    private final void readFont(TypedArray array) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.setFont(array.getFont(R.styleable.ChipTextView_ctv_font));
        }
    }

    private final void readChipPadding(TypedArray array) {
        TypedArray typedArray;
        TypedArray $receiver = typedArray = array;
        int padding = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPadding, 0);
        int paddingHorizontal = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingHorizontal, padding);
        int paddingVertical = $receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingVertical, padding);
        this.setChipPadding(padding);
        this.setChipHorizontalPadding(paddingHorizontal);
        this.setChipVerticalPadding(paddingVertical);
        this.setChipPaddingStart($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingStart, paddingHorizontal));
        this.setChipPaddingEnd($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingEnd, paddingHorizontal));
        this.setChipPaddingTop($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingTop, paddingVertical));
        this.setChipPaddingBottom($receiver.getDimensionPixelSize(R.styleable.ChipTextView_ctv_chipPaddingBottom, paddingVertical));
    }

    public final void setChipPadding(int padding) {
        this.setChipPaddingStart(padding);
        this.setChipPaddingEnd(padding);
        this.setChipPaddingTop(padding);
        this.setChipPaddingBottom(padding);
    }

    public final void setChipHorizontalPadding(int padding) {
        this.setChipPaddingStart(padding);
        this.setChipPaddingEnd(padding);
    }

    public final void setChipVerticalPadding(int padding) {
        this.setChipPaddingTop(padding);
        this.setChipPaddingBottom(padding);
    }

    public final void setChipPadding(int left, int top, int right, int bottom) {
        this.setChipPaddingStart(left);
        this.setChipPaddingTop(top);
        this.setChipPaddingEnd(right);
        this.setChipPaddingBottom(bottom);
    }

    public final void setChipBackgroundDrawable(@Nullable Drawable drawable) {
        if (drawable == null) {
            RoundedCornersDrawable roundedCornersDrawable = this.chipBackgroundDrawable;
            if (roundedCornersDrawable != null) {
                roundedCornersDrawable.setCallback(null);
            }
            this.chipBackgroundDrawable = null;
        } else {
            RoundedCornersDrawable roundedCornersDrawable;
            RoundedCornersDrawable roundedCornersDrawable2 = new RoundedCornersDrawable(drawable);
            ChipTextView chipTextView = this;
            RoundedCornersDrawable it = roundedCornersDrawable2;
            it.setCallback((Drawable.Callback)this);
            it.setState(this.getDrawableState());
            chipTextView.chipBackgroundDrawable = roundedCornersDrawable = roundedCornersDrawable2;
        }
        this.invalidate();
    }

    public final void strikeThroughText() {
        this.setPaintFlags(this.getPaintFlags() | 0x10);
        this.invalidate();
    }

    public final void hideStrikeThroughText() {
        this.setPaintFlags(this.getPaintFlags() & ~16);
        this.invalidate();
    }

    public final void underlineText() {
        this.setPaintFlags(this.getPaintFlags() | 8);
        this.invalidate();
    }

    public final void hideTextUnderline() {
        this.setPaintFlags(this.getPaintFlags() & ~8);
        this.invalidate();
    }

    protected boolean verifyDrawable(@Nullable Drawable who) {
        Drawable drawable;
        Drawable it;
        Drawable drawable2 = who;
        return drawable2 != null ? super.verifyDrawable(it = (drawable = drawable2)) || it == this.chipBackgroundDrawable : false;
    }

    protected void drawableStateChanged() {
        block0: {
            super.drawableStateChanged();
            RoundedCornersDrawable roundedCornersDrawable = this.chipBackgroundDrawable;
            if (roundedCornersDrawable == null) break block0;
            roundedCornersDrawable.setState(this.getDrawableState());
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        block0: {
            super.drawableHotspotChanged(x, y);
            RoundedCornersDrawable roundedCornersDrawable = this.chipBackgroundDrawable;
            if (roundedCornersDrawable == null) break block0;
            roundedCornersDrawable.setHotspot(x, y);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int preferredWidth = 0;
        int preferredHeight = 0;
        String string = this.text;
        if (string != null) {
            String string2;
            String it = string2 = string;
            this.textPaint.getTextBounds(it, 0, it.length(), this.textMeasuringRect);
            int textWidth = MathKt.roundToInt((float)this.textPaint.measureText(it));
            int textHeight = this.textMeasuringRect.height();
            if (it.length() == 1) {
                int max;
                preferredWidth = max = Math.max(textWidth, textHeight);
                preferredHeight = max;
            } else {
                preferredWidth = textWidth;
                preferredHeight = textHeight;
            }
            preferredWidth += this.getPaddingLeft() + this.getPaddingRight() + this.chipPaddingStart + this.chipPaddingEnd;
            preferredHeight += this.getPaddingTop() + this.getPaddingBottom() + this.chipPaddingTop + this.chipPaddingBottom;
        }
        int finalWidth = View.resolveSize((int)preferredWidth, (int)widthMeasureSpec);
        int finalHeight = View.resolveSize((int)preferredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.calcChipBackgroundRect();
        this.drawChipBackgroundColor(canvas);
        this.drawChipBackgroundDrawable(canvas);
        this.drawText(canvas);
    }

    private final void calcChipBackgroundRect() {
        RectF rectF;
        RectF $receiver = rectF = this.chipBackgroundRect;
        $receiver.left = this.getPaddingLeft();
        $receiver.top = this.getPaddingTop();
        $receiver.right = this.getWidth() - this.getPaddingRight();
        $receiver.bottom = this.getHeight() - this.getPaddingBottom();
        $receiver.round(this.chipBackgroundDrawableRect);
    }

    private final void drawChipBackgroundColor(Canvas canvas) {
        float cornerRadius = this.chipBackgroundRect.height() / (float)2;
        canvas.drawRoundRect(this.chipBackgroundRect, cornerRadius, cornerRadius, this.backgroundPaint);
    }

    private final void drawChipBackgroundDrawable(Canvas canvas) {
        block0: {
            RoundedCornersDrawable roundedCornersDrawable;
            RoundedCornersDrawable roundedCornersDrawable2 = this.chipBackgroundDrawable;
            if (roundedCornersDrawable2 == null) break block0;
            RoundedCornersDrawable $receiver = roundedCornersDrawable = roundedCornersDrawable2;
            $receiver.setBounds(this.chipBackgroundDrawableRect);
            $receiver.draw(canvas);
        }
    }

    private final void drawText(Canvas canvas) {
        block0: {
            String string;
            String string2 = this.text;
            if (string2 == null) break block0;
            String it = string = string2;
            this.textPaint.getTextBounds(it, 0, it.length(), this.textMeasuringRect);
            float textWidth = this.textPaint.measureText(it);
            int textHeight = this.textMeasuringRect.height();
            int clientWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - this.chipPaddingStart - this.chipPaddingEnd;
            int clientHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.chipPaddingTop - this.chipPaddingBottom;
            float textX = (float)(this.getPaddingLeft() + this.chipPaddingStart) + ((float)clientWidth - textWidth) / 2.0f;
            float textY = (float)(this.getPaddingTop() + this.chipPaddingTop - this.textMeasuringRect.top) + (float)(clientHeight - textHeight) / 2.0f;
            canvas.drawText(it, textX, textY, (Paint)this.textPaint);
        }
    }

    public ChipTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        block0: {
            AttributeSet attributeSet;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context, attrs, defStyleAttr);
            this.textPaint = new TextPaint(1);
            this.backgroundPaint = new Paint(1);
            this.textMeasuringRect = new Rect();
            this.chipBackgroundRect = new RectF();
            this.chipBackgroundDrawableRect = new Rect();
            AttributeSet attributeSet2 = attrs;
            if (attributeSet2 == null) break block0;
            AttributeSet it = attributeSet = attributeSet2;
            this.readAttributes(context, it, defStyleAttr);
        }
    }

    public ChipTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, R.attr.chipTextViewStyle);
    }

    public ChipTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }
}

