/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.util.stream;

import com.aol.cyclops.Monoid;
import com.aol.cyclops.Reducer;
import com.aol.cyclops.control.AnyM;
import com.aol.cyclops.control.ReactiveSeq;
import com.aol.cyclops.data.collections.extensions.CollectionX;
import com.aol.cyclops.data.collections.extensions.standard.ListX;
import com.aol.cyclops.data.collections.extensions.standard.MapX;
import com.aol.cyclops.types.Filterable;
import com.aol.cyclops.types.Functor;
import com.aol.cyclops.types.IterableFoldable;
import com.aol.cyclops.types.Traversable;
import com.aol.cyclops.types.Unit;
import com.aol.cyclops.types.applicative.zipping.ZippingApplicativable;
import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.types.stream.CyclopsCollectable;
import com.aol.cyclops.types.stream.HotStream;
import com.aol.cyclops.types.stream.ToStream;
import com.aol.cyclops.types.stream.future.FutureOperations;
import com.aol.cyclops.types.stream.reactive.SeqSubscriber;
import com.aol.cyclops.util.stream.AsStreamable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jooq.lambda.Collectable;
import org.jooq.lambda.Seq;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;
import org.jooq.lambda.tuple.Tuple3;
import org.jooq.lambda.tuple.Tuple4;
import org.reactivestreams.Publisher;

public interface Streamable<T>
extends ToStream<T>,
IterableFoldable<T>,
CyclopsCollectable<T>,
ConvertableSequence<T>,
Functor<T>,
Filterable<T>,
Traversable<T>,
Unit<T>,
ZippingApplicativable<T> {
    @Override
    default public Collectable<T> collectable() {
        return Seq.seq(this.stream());
    }

    @Override
    default public Streamable<T> combine(BiPredicate<? super T, ? super T> predicate, BinaryOperator<T> op) {
        return Streamable.fromIterable(ZippingApplicativable.super.combine(predicate, op));
    }

    @Override
    default public <U, R> Streamable<R> zip(Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip(other, zipper));
    }

    @Override
    default public <U, R> Streamable<R> zip(Seq<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip(other, zipper));
    }

    @Override
    default public <U, R> Streamable<R> zip(Stream<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip(other, zipper));
    }

    @Override
    default public <U> Streamable<Tuple2<T, U>> zip(Stream<? extends U> other) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip(other));
    }

    @Override
    default public <S, U> Streamable<Tuple3<T, S, U>> zip3(Stream<? extends S> second, Stream<? extends U> third) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip3(second, third));
    }

    @Override
    default public <T2, T3, T4> Streamable<Tuple4<T, T2, T3, T4>> zip4(Stream<? extends T2> second, Stream<? extends T3> third, Stream<? extends T4> fourth) {
        return Streamable.fromIterable(ZippingApplicativable.super.zip4(second, third, fourth));
    }

    @Override
    default public Streamable<ListX<T>> groupedStatefullyWhile(BiPredicate<ListX<? super T>, ? super T> predicate) {
        return Streamable.fromIterable(ZippingApplicativable.super.groupedStatefullyWhile(predicate));
    }

    @Override
    default public <K, A, D> Streamable<Tuple2<K, D>> grouped(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return Streamable.fromIterable(ZippingApplicativable.super.grouped(classifier, downstream));
    }

    @Override
    default public <K> Streamable<Tuple2<K, Seq<T>>> grouped(Function<? super T, ? extends K> classifier) {
        return Streamable.fromIterable(ZippingApplicativable.super.grouped(classifier));
    }

    @Override
    default public Streamable<T> takeWhile(Predicate<? super T> p) {
        return (Streamable)ZippingApplicativable.super.takeWhile(p);
    }

    @Override
    default public Streamable<T> dropWhile(Predicate<? super T> p) {
        return (Streamable)ZippingApplicativable.super.dropWhile(p);
    }

    @Override
    default public Streamable<T> takeUntil(Predicate<? super T> p) {
        return (Streamable)ZippingApplicativable.super.takeUntil(p);
    }

    @Override
    default public Streamable<T> dropUntil(Predicate<? super T> p) {
        return (Streamable)ZippingApplicativable.super.dropUntil(p);
    }

    @Override
    default public Streamable<T> dropRight(int num) {
        return (Streamable)ZippingApplicativable.super.dropRight(num);
    }

    @Override
    default public Streamable<T> takeRight(int num) {
        return (Streamable)ZippingApplicativable.super.takeRight(num);
    }

    public static <T> Streamable<T> fromPublisher(Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher);
        SeqSubscriber sub = SeqSubscriber.subscriber();
        publisher.subscribe(sub);
        return Streamable.fromStream(sub.stream());
    }

    public static <T> Streamable<T> fromStream(Stream<T> stream) {
        return AsStreamable.fromStream(stream);
    }

    public static <T> Streamable<T> fromIterable(Iterable<T> iterable) {
        return AsStreamable.fromIterable(iterable);
    }

    public static <T> Streamable<T> fromIterator(Iterator<T> it) {
        return AsStreamable.fromIterable(() -> it);
    }

    @Override
    default public <T> Streamable<T> unit(T t) {
        return Streamable.of(t);
    }

    @Override
    default public <T> Streamable<T> unitIterator(Iterator<T> it) {
        return Streamable.fromIterator(it);
    }

    public static <T> Streamable<T> of(final T ... values) {
        final List<T> it = Arrays.asList(values);
        return new Streamable<T>(){

            @Override
            public ReactiveSeq<T> stream() {
                return ReactiveSeq.of(values);
            }

            @Override
            public Iterable<T> getStreamable() {
                return it;
            }

            @Override
            public ReactiveSeq<T> reactiveSeq() {
                return ReactiveSeq.of(values);
            }
        };
    }

    public static <T> Streamable<T> empty() {
        return Streamable.of(new Object[0]);
    }

    default public Streamable<T> tail() {
        return Streamable.fromStream(this.reactiveSeq().headAndTail().tail());
    }

    default public T head() {
        return this.reactiveSeq().headAndTail().head();
    }

    default public Streamable<T> appendAll(Streamable<T> t) {
        return Streamable.fromStream(this.reactiveSeq().appendStream(t.reactiveSeq()));
    }

    default public Streamable<T> remove(T t) {
        return Streamable.fromStream(this.reactiveSeq().remove((Object)t));
    }

    default public Streamable<T> prepend(T t) {
        return Streamable.fromStream(this.reactiveSeq().prepend((Object)t));
    }

    @Override
    default public Streamable<T> distinct() {
        return Streamable.fromStream(this.reactiveSeq().distinct());
    }

    default public <U> U foldLeft(U identity, BiFunction<U, ? super T, U> function) {
        return (U)this.reactiveSeq().foldLeft(identity, function);
    }

    @Override
    default public <U> U foldRight(U seed, BiFunction<? super T, ? super U, ? extends U> function) {
        return this.reactiveSeq().foldRight(seed, function);
    }

    @Override
    default public <R> Streamable<R> map(Function<? super T, ? extends R> fn) {
        return Streamable.fromStream(this.reactiveSeq().map((Function)fn));
    }

    @Override
    default public Streamable<T> peek(Consumer<? super T> fn) {
        return Streamable.fromStream(this.reactiveSeq().peek((Consumer)fn));
    }

    @Override
    default public Streamable<T> filter(Predicate<? super T> fn) {
        return Streamable.fromStream(this.reactiveSeq().filter((Predicate)fn));
    }

    default public <R> Streamable<R> flatMap(Function<? super T, Streamable<? extends R>> fn) {
        return Streamable.fromStream(this.reactiveSeq().flatMap((T i) -> ((Streamable)fn.apply(i)).reactiveSeq()));
    }

    @Override
    default public long count() {
        return this.reactiveSeq().count();
    }

    default public void forEachOrdered(Consumer<? super T> action) {
        this.reactiveSeq().forEachOrdered(action);
    }

    default public Object[] toArray() {
        return this.reactiveSeq().toArray();
    }

    default public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.reactiveSeq().toArray(generator);
    }

    @Override
    default public List<T> toList() {
        if (this.getStreamable() instanceof List) {
            return ListX.fromIterable((List)this.getStreamable());
        }
        return this.reactiveSeq().toList();
    }

    default public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.reactiveSeq().collect(supplier, accumulator, combiner);
    }

    @Override
    default public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.reactiveSeq().collect(collector);
    }

    @Override
    default public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return this.reactiveSeq().toCollection(collectionFactory);
    }

    default public Streamable<Streamable<T>> permutations() {
        if (this.isEmpty()) {
            return Streamable.empty();
        }
        Streamable<T> tail = this.tail();
        if (tail.isEmpty()) {
            return Streamable.of(this);
        }
        Streamable<T> zero = Streamable.empty();
        return this.distinct().foldLeft(zero, (xs, x) -> {
            Function<Streamable, Streamable> prepend = l -> l.prepend((T)x);
            return xs.appendAll((Streamable<T>)this.remove(x).permutations().map(prepend));
        });
    }

    default public Streamable<T> subStream(int start, int end) {
        return Streamable.fromStream(this.reactiveSeq().subStream(start, end));
    }

    default public T elementAt(int index) {
        return (T)this.reactiveSeq().elementAt((long)((long)index)).v1;
    }

    default public int size() {
        return this.reactiveSeq().size();
    }

    default public Streamable<Streamable<T>> combinations(int size) {
        if (size == 0) {
            return Streamable.of(Streamable.empty());
        }
        return Streamable.fromStream(IntStream.range(0, this.size()).boxed().flatMap((? super T i) -> this.subStream(i + 1, this.size()).combinations(size - 1).map((T t) -> t.prepend(this.elementAt((int)i))).reactiveSeq()));
    }

    default public Streamable<Streamable<T>> combinations() {
        return Streamable.range(0, this.size() + 1).map(this::combinations).flatMap(s -> s);
    }

    default public <T1> Streamable<T1> flatten() {
        return Streamable.fromStream(this.reactiveSeq().flatten());
    }

    @Override
    default public Optional<ListX<T>> toOptional() {
        return this.reactiveSeq().toOptional();
    }

    @Override
    default public CompletableFuture<ListX<T>> toCompletableFuture() {
        return this.reactiveSeq().toCompletableFuture();
    }

    @Override
    default public Streamable<T> cycle(int times) {
        return Streamable.fromStream(this.reactiveSeq().cycle(times));
    }

    default public Streamable<T> cycle() {
        return Streamable.fromStream(this.reactiveSeq().cycle());
    }

    default public Tuple2<Streamable<T>, Streamable<T>> duplicate() {
        return Tuple.tuple((Object)this, (Object)this);
    }

    default public Tuple3<Streamable<T>, Streamable<T>, Streamable<T>> triplicate() {
        return Tuple.tuple((Object)this, (Object)this, (Object)this);
    }

    default public Tuple4<Streamable<T>, Streamable<T>, Streamable<T>, Streamable<T>> quadruplicate() {
        return Tuple.tuple((Object)this, (Object)this, (Object)this, (Object)this);
    }

    default public Tuple2<Streamable<T>, Streamable<T>> splitAt(int where) {
        return this.reactiveSeq().splitAt(where).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Optional<T>, Streamable<T>> splitAtHead() {
        return this.reactiveSeq().splitAtHead().map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Streamable<T>, Streamable<T>> splitBy(Predicate<T> splitter) {
        return this.reactiveSeq().splitBy(splitter).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    default public Tuple2<Streamable<T>, Streamable<T>> partition(Predicate<T> splitter) {
        return this.reactiveSeq().partitionSequence(splitter).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    @Override
    default public Streamable<T> cycle(Monoid<T> m, int times) {
        return Streamable.fromStream(this.reactiveSeq().cycle((Monoid)m, times));
    }

    @Override
    default public Streamable<T> cycleWhile(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.reactiveSeq().cycleWhile((Predicate)predicate));
    }

    @Override
    default public Streamable<T> cycleUntil(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.reactiveSeq().cycleUntil((Predicate)predicate));
    }

    @Override
    default public <U> Streamable<Tuple2<T, U>> zip(Iterable<? extends U> other) {
        return Streamable.fromStream(this.reactiveSeq().zip((Iterable)other));
    }

    @Override
    default public <U> Streamable<Tuple2<T, U>> zip(Seq<? extends U> other) {
        return Streamable.fromStream(this.reactiveSeq().zip((Seq)other));
    }

    @Override
    default public <S, U> Streamable<Tuple3<T, S, U>> zip3(Streamable<? extends S> second, Streamable<? extends U> third) {
        return Streamable.fromStream(this.reactiveSeq().zip3((Stream)second.reactiveSeq(), (Stream)third.reactiveSeq()));
    }

    @Override
    default public <T2, T3, T4> Streamable<Tuple4<T, T2, T3, T4>> zip4(Streamable<? extends T2> second, Streamable<? extends T3> third, Streamable<? extends T4> fourth) {
        return Streamable.fromStream(this.reactiveSeq().zip4((Stream)second.reactiveSeq(), (Stream)third.reactiveSeq(), (Stream)fourth.reactiveSeq()));
    }

    @Override
    default public Streamable<Tuple2<T, Long>> zipWithIndex() {
        return Streamable.fromStream(this.reactiveSeq().zipWithIndex());
    }

    default public <S, R> Streamable<R> zipStream(BaseStream<? extends S, ? extends BaseStream<? extends S, ?>> second, BiFunction<? super T, ? super S, ? extends R> zipper) {
        return Streamable.fromStream(this.reactiveSeq().zipStream(second, zipper));
    }

    @Override
    default public Streamable<ListX<T>> sliding(int windowSize) {
        return Streamable.fromStream(this.reactiveSeq().sliding(windowSize));
    }

    @Override
    default public Streamable<ListX<T>> sliding(int windowSize, int increment) {
        return Streamable.fromStream(this.reactiveSeq().sliding(windowSize, increment));
    }

    @Override
    default public Streamable<ListX<T>> grouped(int groupSize) {
        return Streamable.fromStream(this.reactiveSeq().grouped(groupSize));
    }

    @Override
    default public <K> MapX<K, List<T>> groupBy(Function<? super T, ? extends K> classifier) {
        return this.reactiveSeq().groupBy((Function)classifier);
    }

    @Override
    default public Streamable<T> scanLeft(Monoid<T> monoid) {
        return Streamable.fromStream(this.reactiveSeq().scanLeft((Monoid)monoid));
    }

    @Override
    default public <U> Streamable<U> scanLeft(U identity, BiFunction<? super U, ? super T, ? extends U> function) {
        return Streamable.fromStream(this.reactiveSeq().scanLeft((Object)identity, (BiFunction)function));
    }

    @Override
    default public Streamable<T> scanRight(Monoid<T> monoid) {
        return Streamable.fromStream(this.reactiveSeq().scanRight((Monoid)monoid));
    }

    @Override
    default public <U> Streamable<U> scanRight(U identity, BiFunction<? super T, ? super U, ? extends U> combiner) {
        return Streamable.fromStream(this.reactiveSeq().scanRight((Object)identity, (BiFunction)combiner));
    }

    @Override
    default public Streamable<T> sorted() {
        return Streamable.fromStream(this.reactiveSeq().sorted());
    }

    @Override
    default public Streamable<T> sorted(Comparator<? super T> c) {
        return Streamable.fromStream(this.reactiveSeq().sorted((Comparator)c));
    }

    @Override
    default public Streamable<T> skip(long num) {
        return Streamable.fromStream(this.reactiveSeq().skip(num));
    }

    @Override
    default public Streamable<T> skipWhile(Predicate<? super T> p) {
        return Streamable.fromStream(this.reactiveSeq().skipWhile((Predicate)p));
    }

    @Override
    default public Streamable<T> skipUntil(Predicate<? super T> p) {
        return Streamable.fromStream(this.reactiveSeq().skipUntil((Predicate)p));
    }

    @Override
    default public Streamable<T> limit(long num) {
        return Streamable.fromStream(this.reactiveSeq().limit(num));
    }

    @Override
    default public Streamable<T> limitWhile(Predicate<? super T> p) {
        return Streamable.fromStream(this.reactiveSeq().limitWhile((Predicate)p));
    }

    @Override
    default public Streamable<T> limitUntil(Predicate<? super T> p) {
        return Streamable.fromStream(this.reactiveSeq().limitUntil((Predicate)p));
    }

    @Override
    default public boolean allMatch(Predicate<? super T> c) {
        return this.reactiveSeq().allMatch(c);
    }

    @Override
    default public boolean anyMatch(Predicate<? super T> c) {
        return this.reactiveSeq().anyMatch(c);
    }

    @Override
    default public boolean xMatch(int num, Predicate<? super T> c) {
        return this.reactiveSeq().xMatch(num, c);
    }

    @Override
    default public boolean noneMatch(Predicate<? super T> c) {
        return this.reactiveSeq().noneMatch(c);
    }

    @Override
    default public String join() {
        return this.reactiveSeq().join();
    }

    @Override
    default public String join(String sep) {
        return this.reactiveSeq().join(sep);
    }

    @Override
    default public String join(String sep, String start, String end) {
        return this.reactiveSeq().join(sep, start, end);
    }

    @Override
    default public <C extends Comparable<? super C>> Optional<T> minBy(Function<? super T, ? extends C> f) {
        return this.reactiveSeq().minBy(f);
    }

    @Override
    default public Optional<T> min(Comparator<? super T> comparator) {
        return this.reactiveSeq().min(comparator);
    }

    @Override
    default public <C extends Comparable<? super C>> Optional<T> maxBy(Function<? super T, ? extends C> f) {
        return this.reactiveSeq().maxBy(f);
    }

    @Override
    default public Optional<T> max(Comparator<? super T> comparator) {
        return this.reactiveSeq().max(comparator);
    }

    @Override
    default public Optional<T> findFirst() {
        return this.reactiveSeq().findFirst();
    }

    @Override
    default public Optional<T> findAny() {
        return this.reactiveSeq().findAny();
    }

    @Override
    default public <R> R mapReduce(Reducer<R> reducer) {
        return this.reactiveSeq().mapReduce(reducer);
    }

    @Override
    default public <R> R mapReduce(Function<? super T, ? extends R> mapper, Monoid<R> reducer) {
        return this.reactiveSeq().mapReduce(mapper, reducer);
    }

    @Override
    default public T reduce(Monoid<T> reducer) {
        return this.reactiveSeq().reduce(reducer);
    }

    @Override
    default public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.reactiveSeq().reduce(accumulator);
    }

    @Override
    default public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.reactiveSeq().reduce(identity, accumulator);
    }

    @Override
    default public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.reactiveSeq().reduce(identity, accumulator, combiner);
    }

    @Override
    default public ListX<T> reduce(Stream<? extends Monoid<T>> reducers) {
        return this.reactiveSeq().reduce(reducers);
    }

    @Override
    default public ListX<T> reduce(Iterable<? extends Monoid<T>> reducers) {
        return this.reactiveSeq().reduce(reducers);
    }

    @Override
    default public T foldRight(Monoid<T> reducer) {
        return this.reactiveSeq().foldRight(reducer);
    }

    @Override
    default public T foldRight(T identity, BinaryOperator<T> accumulator) {
        return this.reactiveSeq().foldRight(identity, accumulator);
    }

    @Override
    default public <T> T foldRightMapToType(Reducer<T> reducer) {
        return this.reactiveSeq().foldRightMapToType(reducer);
    }

    @Override
    default public boolean startsWithIterable(Iterable<T> iterable) {
        return this.reactiveSeq().startsWithIterable(iterable);
    }

    @Override
    default public boolean startsWith(Stream<T> iterator) {
        return this.reactiveSeq().startsWith(iterator);
    }

    default public AnyM<T> anyM() {
        return AnyM.fromStreamable(this);
    }

    default public <R> Streamable<R> flatMapAnyM(Function<? super T, AnyM<? extends R>> fn) {
        return Streamable.fromStream(this.reactiveSeq().flatMapAnyM(fn));
    }

    default public <R> Streamable<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> fn) {
        return Streamable.fromStream(this.reactiveSeq().flatMapIterable(fn));
    }

    default public <R> Streamable<R> flatMapStream(Function<? super T, BaseStream<? extends R, ?>> fn) {
        return Streamable.fromStream(this.reactiveSeq().flatMapStream(fn));
    }

    @Override
    default public Streamable<T> intersperse(T value) {
        return Streamable.fromStream(this.reactiveSeq().intersperse((Object)value));
    }

    @Override
    default public <U> Streamable<U> ofType(Class<? extends U> type) {
        return Streamable.fromStream(this.reactiveSeq().ofType((Class)type));
    }

    @Override
    default public <U> Streamable<U> cast(Class<? extends U> type) {
        return Streamable.fromStream(this.reactiveSeq().cast((Class)type));
    }

    @Override
    default public CollectionX<T> toLazyCollection() {
        return this.reactiveSeq().toLazyCollection();
    }

    @Override
    default public CollectionX<T> toConcurrentLazyCollection() {
        return this.reactiveSeq().toConcurrentLazyCollection();
    }

    @Override
    default public Streamable<T> reverse() {
        return Streamable.fromStream(this.reactiveSeq().reverse());
    }

    @Override
    default public Streamable<T> shuffle() {
        return Streamable.fromStream(this.reactiveSeq().shuffle());
    }

    default public Streamable<T> appendStreamable(Streamable<T> stream) {
        return Streamable.fromStream(this.reactiveSeq().appendStream(stream.reactiveSeq()));
    }

    default public Streamable<T> prependStreamable(Streamable<T> stream) {
        return Streamable.fromStream(this.reactiveSeq().prependStream(stream.reactiveSeq()));
    }

    default public Streamable<T> append(T ... values) {
        return Streamable.fromStream(this.reactiveSeq().append((Object[])values));
    }

    default public Streamable<T> prepend(T ... values) {
        return Streamable.fromStream(this.reactiveSeq().prepend((Object[])values));
    }

    default public Streamable<T> insertAt(int pos, T ... values) {
        return Streamable.fromStream(this.reactiveSeq().insertAt(pos, values));
    }

    default public Streamable<T> deleteBetween(int start, int end) {
        return Streamable.fromStream(this.reactiveSeq().deleteBetween(start, end));
    }

    default public Streamable<T> insertStreamableAt(int pos, Streamable<T> stream) {
        return Streamable.fromStream(this.reactiveSeq().insertStreamAt(pos, stream.reactiveSeq()));
    }

    @Override
    default public FutureOperations<T> futureOperations(Executor exec) {
        return this.reactiveSeq().futureOperations(exec);
    }

    @Override
    default public boolean endsWithIterable(Iterable<T> iterable) {
        return this.reactiveSeq().endsWithIterable(iterable);
    }

    @Override
    default public boolean endsWith(Streamable<T> stream) {
        return this.reactiveSeq().endsWithIterable(stream);
    }

    default public Streamable<T> skip(long time, TimeUnit unit) {
        return Streamable.fromStream(this.reactiveSeq().skip(time, unit));
    }

    default public Streamable<T> limit(long time, TimeUnit unit) {
        return Streamable.fromStream(this.reactiveSeq().limit(time, unit));
    }

    @Override
    default public Streamable<T> skipLast(int num) {
        return Streamable.fromStream(this.reactiveSeq().skipLast(num));
    }

    @Override
    default public Streamable<T> limitLast(int num) {
        return Streamable.fromStream(this.reactiveSeq().limitLast(num));
    }

    default public HotStream<T> hotStream(Executor e) {
        return this.reactiveSeq().hotStream(e);
    }

    @Override
    default public T firstValue() {
        return this.reactiveSeq().firstValue();
    }

    @Override
    default public T single() {
        return this.reactiveSeq().single();
    }

    @Override
    default public Optional<T> get(long index) {
        return this.reactiveSeq().get(index);
    }

    default public Tuple2<T, Streamable<T>> elementAt(long index) {
        return this.reactiveSeq().elementAt(index).map2(s -> Streamable.fromStream(s));
    }

    default public Streamable<Tuple2<T, Long>> elapsed() {
        return Streamable.fromStream(this.reactiveSeq().elapsed());
    }

    default public Streamable<Tuple2<T, Long>> timestamp() {
        return Streamable.fromStream(this.reactiveSeq().timestamp());
    }

    public static <T> Streamable<T> reversedOf(T ... elements) {
        return Streamable.fromStream(ReactiveSeq.reversedOf(elements));
    }

    public static <T> Streamable<T> reversedListOf(List<T> elements) {
        Objects.requireNonNull(elements);
        return Streamable.fromStream(ReactiveSeq.reversedListOf(elements));
    }

    public static Streamable<Integer> range(int start, int end) {
        return Streamable.fromStream(ReactiveSeq.range(start, end));
    }

    public static Streamable<Long> rangeLong(long start, long end) {
        return Streamable.fromStream(ReactiveSeq.rangeLong(start, end));
    }

    public static Streamable<Integer> fromIntStream(IntStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(ReactiveSeq.fromIntStream(stream));
    }

    public static Streamable<Long> fromLongStream(LongStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(ReactiveSeq.fromLongStream(stream));
    }

    public static Streamable<Double> fromDoubleStream(DoubleStream stream) {
        Objects.requireNonNull(stream);
        return Streamable.fromStream(ReactiveSeq.fromDoubleStream(stream));
    }

    public static <T> Streamable<T> fromList(List<T> list) {
        Objects.requireNonNull(list);
        return AsStreamable.fromIterable(list);
    }

    public static <T> Streamable<T> iterate(T seed, UnaryOperator<T> f) {
        Objects.requireNonNull(f);
        return Streamable.fromStream(ReactiveSeq.iterate(seed, f));
    }

    public static <T> Streamable<T> generate(Supplier<T> s) {
        Objects.requireNonNull(s);
        return Streamable.fromStream(ReactiveSeq.generate(s));
    }

    public static <T, U> Tuple2<Streamable<T>, Streamable<U>> unzip(Streamable<Tuple2<T, U>> sequence) {
        return ReactiveSeq.unzip(sequence.reactiveSeq()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s));
    }

    public static <T1, T2, T3> Tuple3<Streamable<T1>, Streamable<T2>, Streamable<T3>> unzip3(Streamable<Tuple3<T1, T2, T3>> sequence) {
        return ReactiveSeq.unzip3(sequence.reactiveSeq()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s)).map3(s -> Streamable.fromStream(s));
    }

    public static <T1, T2, T3, T4> Tuple4<Streamable<T1>, Streamable<T2>, Streamable<T3>, Streamable<T4>> unzip4(Streamable<Tuple4<T1, T2, T3, T4>> sequence) {
        return ReactiveSeq.unzip4(sequence.reactiveSeq()).map1(s -> Streamable.fromStream(s)).map2(s -> Streamable.fromStream(s)).map3(s -> Streamable.fromStream(s)).map4(s -> Streamable.fromStream(s));
    }

    default public <U> Streamable<Tuple2<T, U>> crossJoin(Streamable<U> other) {
        return Streamable.fromStream(this.reactiveSeq().crossJoin(other.reactiveSeq()));
    }

    default public <U> Streamable<Tuple2<T, U>> innerJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.reactiveSeq().innerJoin(other.reactiveSeq(), (BiPredicate)predicate));
    }

    default public <U> Streamable<Tuple2<T, U>> leftOuterJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.reactiveSeq().leftOuterJoin(other.reactiveSeq(), (BiPredicate)predicate));
    }

    default public <U> Streamable<Tuple2<T, U>> rightOuterJoin(Streamable<U> other, BiPredicate<T, U> predicate) {
        return Streamable.fromStream(this.reactiveSeq().rightOuterJoin(other.reactiveSeq(), (BiPredicate)predicate));
    }

    default public Streamable<T> onEmptySwitch(Supplier<Streamable<T>> switchTo) {
        return Streamable.fromStream(this.reactiveSeq().onEmptySwitch(() -> ((Streamable)switchTo.get()).reactiveSeq()));
    }

    @Override
    default public Streamable<T> onEmpty(T value) {
        return Streamable.fromStream(this.reactiveSeq().onEmpty((Object)value));
    }

    @Override
    default public Streamable<T> onEmptyGet(Supplier<? extends T> supplier) {
        return Streamable.fromStream(this.reactiveSeq().onEmptyGet((Supplier)supplier));
    }

    @Override
    default public <X extends Throwable> Streamable<T> onEmptyThrow(Supplier<? extends X> supplier) {
        return Streamable.fromStream(this.reactiveSeq().onEmptyThrow((Supplier)supplier));
    }

    default public Streamable<T> concat(Streamable<T> other) {
        return Streamable.fromStream(this.reactiveSeq().concat(other.reactiveSeq()));
    }

    default public Streamable<T> concat(T other) {
        return Streamable.fromStream(this.reactiveSeq().concat((Object)other));
    }

    default public Streamable<T> concat(T ... other) {
        return Streamable.fromStream(this.reactiveSeq().concat((Object[])other));
    }

    default public <U> Streamable<T> distinct(Function<? super T, ? extends U> keyExtractor) {
        return Streamable.fromStream(this.reactiveSeq().distinct((Function)keyExtractor));
    }

    @Override
    default public Streamable<T> shuffle(Random random) {
        return Streamable.fromStream(this.reactiveSeq().shuffle(random));
    }

    @Override
    default public Streamable<T> slice(long from, long to) {
        return Streamable.fromStream(this.reactiveSeq().slice(from, to));
    }

    @Override
    default public <U extends Comparable<? super U>> Streamable<T> sorted(Function<? super T, ? extends U> function) {
        return Streamable.fromStream(this.reactiveSeq().sorted((Function)function));
    }

    default public Streamable<T> xPer(int x, long time, TimeUnit t) {
        return Streamable.fromStream(this.reactiveSeq().xPer(x, time, t));
    }

    default public Streamable<T> onePer(long time, TimeUnit t) {
        return Streamable.fromStream(this.reactiveSeq().onePer(time, t));
    }

    default public Streamable<T> debounce(long time, TimeUnit t) {
        return Streamable.fromStream(this.reactiveSeq().debounce(time, t));
    }

    default public Streamable<ListX<T>> groupedBySizeAndTime(int size, long time, TimeUnit t) {
        return Streamable.fromStream(this.reactiveSeq().groupedBySizeAndTime(size, time, t));
    }

    default public <C extends Collection<? super T>> Streamable<C> groupedBySizeAndTime(int size, long time, TimeUnit unit, Supplier<C> factory2) {
        return Streamable.fromStream(this.reactiveSeq().groupedBySizeAndTime(size, time, unit, factory2));
    }

    default public Streamable<ListX<T>> groupedByTime(long time, TimeUnit t) {
        return Streamable.fromStream(this.reactiveSeq().groupedByTime(time, t));
    }

    default public <C extends Collection<? super T>> Streamable<C> groupedByTime(long time, TimeUnit unit, Supplier<C> factory2) {
        return Streamable.fromStream(this.reactiveSeq().groupedByTime(time, unit, factory2));
    }

    @Override
    default public <C extends Collection<? super T>> Streamable<C> grouped(int size, Supplier<C> supplier) {
        return Streamable.fromStream(this.reactiveSeq().grouped(size, (Supplier)supplier));
    }

    default public Streamable<T> fixedDelay(long l, TimeUnit unit) {
        return Streamable.fromStream(this.reactiveSeq().fixedDelay(l, unit));
    }

    default public Streamable<T> jitter(long maxJitterPeriodInNanos) {
        return Streamable.fromStream(this.reactiveSeq().jitter(maxJitterPeriodInNanos));
    }

    @Override
    default public Streamable<ListX<T>> groupedUntil(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.reactiveSeq().groupedUntil((Predicate)predicate));
    }

    @Override
    default public Streamable<ListX<T>> groupedWhile(Predicate<? super T> predicate) {
        return Streamable.fromStream(this.reactiveSeq().groupedWhile((Predicate)predicate));
    }

    @Override
    default public <C extends Collection<? super T>> Streamable<C> groupedWhile(Predicate<? super T> predicate, Supplier<C> factory2) {
        return Streamable.fromStream(this.reactiveSeq().groupedWhile((Predicate)predicate, (Supplier)factory2));
    }

    @Override
    default public <C extends Collection<? super T>> Streamable<C> groupedUntil(Predicate<? super T> predicate, Supplier<C> factory2) {
        return Streamable.fromStream(this.reactiveSeq().groupedUntil((Predicate)predicate, (Supplier)factory2));
    }

    default public Streamable<T> recover(Function<Throwable, ? extends T> fn) {
        return Streamable.fromStream(this.reactiveSeq().recover(fn));
    }

    default public <EX extends Throwable> Streamable<T> recover(Class<EX> exceptionClass, Function<EX, T> fn) {
        return Streamable.fromStream(this.reactiveSeq().recover(exceptionClass, fn));
    }

    default public <R> Streamable<R> retry(Function<T, R> fn) {
        return Streamable.fromStream(this.reactiveSeq().retry(fn));
    }

    default public boolean contains(T t) {
        return this.stream().anyMatch(c -> t.equals(c));
    }

    @Override
    default public ReactiveSeq<T> stream() {
        return ToStream.super.reactiveSeq();
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }
}

