/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.reactive;

import com.aol.cyclops.types.stream.ConvertableSequence;
import com.aol.cyclops.util.ExceptionSoftener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SeqSubscriber<T>
implements Subscriber<T>,
Supplier<T>,
ConvertableSequence<T> {
    private final Object UNSET = new Object();
    private final AtomicReference lastValue = new AtomicReference<Object>(this.UNSET);
    private final AtomicReference lastError = new AtomicReference<Object>(this.UNSET);
    private final Runnable onComplete;
    private volatile boolean complete = false;
    private volatile boolean unread = false;
    private volatile Subscription s;

    protected SeqSubscriber() {
        this.onComplete = () -> {};
    }

    private SeqSubscriber(Runnable onComplete) {
        this.onComplete = onComplete;
    }

    public static <T> SeqSubscriber<T> subscriber(Runnable onComplete) {
        return new SeqSubscriber<T>(onComplete);
    }

    public static <T> SeqSubscriber<T> subscriber() {
        return new SeqSubscriber<T>(() -> {});
    }

    public void onSubscribe(Subscription s) {
        Objects.requireNonNull(s);
        if (this.s == null) {
            this.s = s;
            s.request(1L);
        } else {
            s.cancel();
        }
    }

    public void onNext(T t) {
        this.unread = true;
        Objects.requireNonNull(t);
        this.lastValue.set(t);
    }

    public void onError(Throwable t) {
        Objects.requireNonNull(t);
        this.lastError.set(t);
    }

    public void onComplete() {
        this.complete = true;
        this.onComplete.run();
    }

    @Override
    public T get() {
        try {
            Object result;
            while (this.lastValue.get() == this.UNSET && this.lastError.get() == this.UNSET) {
                LockSupport.parkNanos(1000000L);
            }
            if (this.lastError.get() != this.UNSET) {
                Throwable toThrow = (Throwable)this.lastError.get();
                this.reset();
                throw ExceptionSoftener.throwSoftenedException(toThrow);
            }
            Object v = result = this.lastValue.get();
            return (T)v;
        }
        finally {
            this.unread = false;
        }
    }

    private void reset() {
        this.lastValue.set(this.UNSET);
        this.lastError.set(this.UNSET);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            boolean requested = true;
            Object next = SeqSubscriber.access$000(SeqSubscriber.this) ? SeqSubscriber.access$100(SeqSubscriber.this) : SeqSubscriber.this.get();

            @Override
            public boolean hasNext() {
                if (!this.requested) {
                    SeqSubscriber.this.reset();
                    SeqSubscriber.this.s.request(1L);
                    this.requested = true;
                    this.next = SeqSubscriber.this.unread ? SeqSubscriber.this.get() : SeqSubscriber.this.UNSET;
                }
                return this.next != SeqSubscriber.this.UNSET;
            }

            @Override
            public T next() {
                if (!this.requested && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.next == SeqSubscriber.this.UNSET) {
                    throw new NoSuchElementException();
                }
                this.requested = false;
                return this.next;
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return new Spliterator<T>(){
            boolean requested = true;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object next;
                if (!this.requested) {
                    SeqSubscriber.this.s.request(1L);
                } else {
                    this.requested = false;
                }
                Object object = SeqSubscriber.this.complete ? (!SeqSubscriber.this.unread ? SeqSubscriber.this.UNSET : SeqSubscriber.this.get()) : (next = SeqSubscriber.this.get());
                if (next != SeqSubscriber.this.UNSET) {
                    action.accept(next);
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                return this;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 1024;
            }
        };
    }
}

