/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.types.stream.reactive;

import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jooq.lambda.tuple.Tuple3;
import org.reactivestreams.Subscription;

public final class ReactiveTask
implements Subscription {
    private final Executor exec;
    private final Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> subscriptionAndTask;

    public void cancel() {
        ((Subscription)((CompletableFuture)this.subscriptionAndTask.v1).join()).cancel();
    }

    public void request(long n) {
        ((Subscription)((CompletableFuture)this.subscriptionAndTask.v1).join()).request(n);
    }

    public boolean isCurrentTaskComplete() {
        return ((CompletableFuture)this.subscriptionAndTask.v2).isDone();
    }

    public boolean isStreamComplete() {
        return ((CompletableFuture)this.subscriptionAndTask.v3).isDone();
    }

    public ReactiveTask requestAsync(long n) {
        return this.withSubscriptionAndTask(this.subscriptionAndTask.map2(c -> CompletableFuture.runAsync(() -> ((Subscription)((CompletableFuture)this.subscriptionAndTask.v1).join()).request(n), this.exec)));
    }

    public void requestAll() {
        this.request(Long.MAX_VALUE);
    }

    public ReactiveTask requestAllAsync() {
        return this.requestAsync(Long.MAX_VALUE);
    }

    public void block() {
        ((CompletableFuture)this.subscriptionAndTask.v2).join();
    }

    @ConstructorProperties(value={"exec", "subscriptionAndTask"})
    public ReactiveTask(Executor exec, Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> subscriptionAndTask) {
        this.exec = exec;
        this.subscriptionAndTask = subscriptionAndTask;
    }

    public Executor getExec() {
        return this.exec;
    }

    public Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> getSubscriptionAndTask() {
        return this.subscriptionAndTask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactiveTask)) {
            return false;
        }
        ReactiveTask other = (ReactiveTask)o;
        Executor this$exec = this.getExec();
        Executor other$exec = other.getExec();
        if (this$exec == null ? other$exec != null : !this$exec.equals(other$exec)) {
            return false;
        }
        Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> this$subscriptionAndTask = this.getSubscriptionAndTask();
        Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> other$subscriptionAndTask = other.getSubscriptionAndTask();
        return !(this$subscriptionAndTask == null ? other$subscriptionAndTask != null : !this$subscriptionAndTask.equals(other$subscriptionAndTask));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Executor $exec = this.getExec();
        result = result * 59 + ($exec == null ? 0 : $exec.hashCode());
        Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> $subscriptionAndTask = this.getSubscriptionAndTask();
        result = result * 59 + ($subscriptionAndTask == null ? 0 : $subscriptionAndTask.hashCode());
        return result;
    }

    public String toString() {
        return "ReactiveTask(exec=" + this.getExec() + ", subscriptionAndTask=" + this.getSubscriptionAndTask() + ")";
    }

    public ReactiveTask withExec(Executor exec) {
        return this.exec == exec ? this : new ReactiveTask(exec, this.subscriptionAndTask);
    }

    public ReactiveTask withSubscriptionAndTask(Tuple3<CompletableFuture<Subscription>, CompletableFuture<?>, CompletableFuture<Boolean>> subscriptionAndTask) {
        return this.subscriptionAndTask == subscriptionAndTask ? this : new ReactiveTask(this.exec, subscriptionAndTask);
    }
}

